/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.builder;

import com.google.common.collect.Ordering;
import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.Language;
import io.github.swagger2markup.OrderBy;
import io.github.swagger2markup.PageBreakLocations;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupProperties;
import io.github.swagger2markup.markup.builder.LineSeparator;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.model.PathOperation;
import io.swagger.models.HttpMethod;
import io.swagger.models.parameters.Parameter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Swagger2MarkupConfigBuilder {
    static final Ordering<PathOperation> OPERATION_METHOD_NATURAL_ORDERING = Ordering.explicit((Object)HttpMethod.POST, (Object[])new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.PATCH, HttpMethod.HEAD, HttpMethod.OPTIONS}).onResultOf(PathOperation::getMethod);
    static final Ordering<PathOperation> OPERATION_PATH_NATURAL_ORDERING = Ordering.natural().onResultOf(PathOperation::getPath);
    static final Ordering<Parameter> PARAMETER_IN_NATURAL_ORDERING = Ordering.explicit((Object)"header", (Object[])new String[]{"path", "query", "formData", "body"}).onResultOf(Parameter::getIn);
    static final Ordering<Parameter> PARAMETER_NAME_NATURAL_ORDERING = Ordering.natural().onResultOf(Parameter::getName);
    private static final String PROPERTIES_DEFAULT = "io/github/swagger2markup/config/default.properties";
    DefaultSwagger2MarkupConfig config = new DefaultSwagger2MarkupConfig();

    public Swagger2MarkupConfigBuilder() {
        this((Configuration)new PropertiesConfiguration());
    }

    public Swagger2MarkupConfigBuilder(Properties properties) {
        this(ConfigurationConverter.getConfiguration((Properties)properties));
    }

    public Swagger2MarkupConfigBuilder(Map<String, String> map) {
        this((Configuration)new MapConfiguration(map));
    }

    public Swagger2MarkupConfigBuilder(Configuration configuration) {
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        compositeConfiguration.addConfiguration((Configuration)new SystemConfiguration());
        compositeConfiguration.addConfiguration(configuration);
        compositeConfiguration.addConfiguration(this.getDefaultConfiguration());
        Swagger2MarkupProperties swagger2MarkupProperties = new Swagger2MarkupProperties((Configuration)compositeConfiguration);
        this.config.listDelimiterEnabled = swagger2MarkupProperties.getBoolean("swagger2markup.listDelimiterEnabled", false);
        this.config.listDelimiter = Character.valueOf(swagger2MarkupProperties.getString("swagger2markup.listDelimiter", ",").charAt(0));
        if (this.config.listDelimiterEnabled && configuration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)configuration).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(this.config.listDelimiter.charValue()));
        }
        this.config.markupLanguage = swagger2MarkupProperties.getRequiredMarkupLanguage("swagger2markup.markupLanguage");
        this.config.swaggerMarkupLanguage = swagger2MarkupProperties.getRequiredMarkupLanguage("swagger2markup.swaggerMarkupLanguage");
        this.config.generatedExamplesEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.generatedExamplesEnabled");
        this.config.basePathPrefixEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.basePathPrefixEnabled");
        this.config.separatedDefinitionsEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.separatedDefinitionsEnabled");
        this.config.separatedOperationsEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.separatedOperationsEnabled");
        this.config.pathsGroupedBy = swagger2MarkupProperties.getGroupBy("swagger2markup.pathsGroupedBy");
        this.config.outputLanguage = swagger2MarkupProperties.getLanguage("swagger2markup.outputLanguage");
        this.config.inlineSchemaEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.inlineSchemaEnabled");
        this.config.interDocumentCrossReferencesEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.interDocumentCrossReferencesEnabled");
        this.config.interDocumentCrossReferencesPrefix = swagger2MarkupProperties.getString("swagger2markup.interDocumentCrossReferencesPrefix", null);
        this.config.flatBodyEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.flatBodyEnabled");
        this.config.pathSecuritySectionEnabled = swagger2MarkupProperties.getRequiredBoolean("swagger2markup.pathSecuritySectionEnabled");
        this.config.anchorPrefix = swagger2MarkupProperties.getString("swagger2markup.anchorPrefix", null);
        this.config.overviewDocument = swagger2MarkupProperties.getRequiredString("swagger2markup.overviewDocument");
        this.config.pathsDocument = swagger2MarkupProperties.getRequiredString("swagger2markup.pathsDocument");
        this.config.definitionsDocument = swagger2MarkupProperties.getRequiredString("swagger2markup.definitionsDocument");
        this.config.securityDocument = swagger2MarkupProperties.getRequiredString("swagger2markup.securityDocument");
        this.config.separatedOperationsFolder = swagger2MarkupProperties.getRequiredString("swagger2markup.separatedOperationsFolder");
        this.config.separatedDefinitionsFolder = swagger2MarkupProperties.getRequiredString("swagger2markup.separatedDefinitionsFolder");
        this.config.tagOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.tagOrderBy");
        this.config.operationOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.operationOrderBy");
        this.config.definitionOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.definitionOrderBy");
        this.config.parameterOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.parameterOrderBy");
        this.config.propertyOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.propertyOrderBy");
        this.config.responseOrderBy = swagger2MarkupProperties.getOrderBy("swagger2markup.responseOrderBy");
        Optional<String> lineSeparator = swagger2MarkupProperties.getString("swagger2markup.lineSeparator");
        if (lineSeparator.isPresent() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lineSeparator.get()})) {
            this.config.lineSeparator = LineSeparator.valueOf((String)lineSeparator.get());
        }
        this.config.pageBreakLocations = swagger2MarkupProperties.getPageBreakLocations("swagger2markup.pageBreakLocations");
        Optional<Pattern> headerPattern = swagger2MarkupProperties.getHeaderPattern("swagger2markup.headerRegex");
        this.config.headerPattern = headerPattern.orElse(null);
        Configuration swagger2markupConfiguration = compositeConfiguration.subset("swagger2markup");
        Configuration extensionsConfiguration = swagger2markupConfiguration.subset("extensions");
        this.config.extensionsProperties = new Swagger2MarkupProperties(extensionsConfiguration);
    }

    private Configuration getDefaultConfiguration() {
        Configurations configs = new Configurations();
        try {
            return configs.properties(PROPERTIES_DEFAULT);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(String.format("Can't load default properties '%s'", PROPERTIES_DEFAULT), e);
        }
    }

    public Swagger2MarkupConfig build() {
        this.buildNaturalOrdering();
        return this.config;
    }

    private void buildNaturalOrdering() {
        if (this.config.tagOrderBy == OrderBy.NATURAL) {
            this.config.tagOrdering = (Comparator)Ordering.natural();
        }
        if (this.config.operationOrderBy == OrderBy.NATURAL) {
            this.config.operationOrdering = (Comparator)Swagger2MarkupConfigBuilder.OPERATION_PATH_NATURAL_ORDERING.compound(Swagger2MarkupConfigBuilder.OPERATION_METHOD_NATURAL_ORDERING);
        }
        if (this.config.definitionOrderBy == OrderBy.NATURAL) {
            this.config.definitionOrdering = (Comparator)Ordering.natural();
        }
        if (this.config.parameterOrderBy == OrderBy.NATURAL) {
            this.config.parameterOrdering = (Comparator)Swagger2MarkupConfigBuilder.PARAMETER_IN_NATURAL_ORDERING.compound(Swagger2MarkupConfigBuilder.PARAMETER_NAME_NATURAL_ORDERING);
        }
        if (this.config.propertyOrderBy == OrderBy.NATURAL) {
            this.config.propertyOrdering = (Comparator)Ordering.natural();
        }
        if (this.config.responseOrderBy == OrderBy.NATURAL) {
            this.config.responseOrdering = (Comparator)Ordering.natural();
        }
    }

    public Swagger2MarkupConfigBuilder withMarkupLanguage(MarkupLanguage markupLanguage) {
        Validate.notNull((Object)markupLanguage, (String)"%s must not be null", (Object[])new Object[]{"markupLanguage"});
        this.config.markupLanguage = markupLanguage;
        return this;
    }

    public Swagger2MarkupConfigBuilder withSwaggerMarkupLanguage(MarkupLanguage swaggerMarkupLanguage) {
        Validate.notNull((Object)swaggerMarkupLanguage, (String)"%s must not be null", (Object[])new Object[]{"swaggerMarkupLanguage"});
        this.config.swaggerMarkupLanguage = swaggerMarkupLanguage;
        return this;
    }

    public Swagger2MarkupConfigBuilder withGeneratedExamples() {
        this.config.generatedExamplesEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withSeparatedDefinitions() {
        this.config.separatedDefinitionsEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withSeparatedOperations() {
        this.config.separatedOperationsEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withListDelimiter() {
        this.config.listDelimiterEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withListDelimiter(Character delimiter) {
        Validate.notNull((Object)delimiter, (String)"%s must not be null", (Object[])new Object[]{"delimiter"});
        this.config.listDelimiter = delimiter;
        this.config.listDelimiterEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withPathsGroupedBy(GroupBy pathsGroupedBy) {
        Validate.notNull((Object)((Object)pathsGroupedBy), (String)"%s must not be null", (Object[])new Object[]{"pathsGroupedBy"});
        this.config.pathsGroupedBy = pathsGroupedBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withHeaderRegex(String headerRegex) {
        Validate.notNull((Object)headerRegex, (String)"%s must not be null", (Object[])new Object[]{headerRegex});
        this.config.headerPattern = Pattern.compile(headerRegex);
        return this;
    }

    public Swagger2MarkupConfigBuilder withOutputLanguage(Language language) {
        Validate.notNull((Object)((Object)language), (String)"%s must not be null", (Object[])new Object[]{"language"});
        this.config.outputLanguage = language;
        return this;
    }

    public Swagger2MarkupConfigBuilder withoutInlineSchema() {
        this.config.inlineSchemaEnabled = false;
        return this;
    }

    public Swagger2MarkupConfigBuilder withTagOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.tagOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withTagOrdering(Comparator<String> tagOrdering) {
        Validate.notNull(tagOrdering, (String)"%s must not be null", (Object[])new Object[]{"tagOrdering"});
        this.config.tagOrderBy = OrderBy.CUSTOM;
        this.config.tagOrdering = tagOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withOperationOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.operationOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withOperationOrdering(Comparator<PathOperation> operationOrdering) {
        Validate.notNull(operationOrdering, (String)"%s must not be null", (Object[])new Object[]{"operationOrdering"});
        this.config.operationOrderBy = OrderBy.CUSTOM;
        this.config.operationOrdering = operationOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withDefinitionOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.definitionOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withDefinitionOrdering(Comparator<String> definitionOrdering) {
        Validate.notNull(definitionOrdering, (String)"%s must not be null", (Object[])new Object[]{"definitionOrdering"});
        this.config.definitionOrderBy = OrderBy.CUSTOM;
        this.config.definitionOrdering = definitionOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withParameterOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.parameterOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withParameterOrdering(Comparator<Parameter> parameterOrdering) {
        Validate.notNull(parameterOrdering, (String)"%s must not be null", (Object[])new Object[]{"parameterOrdering"});
        this.config.parameterOrderBy = OrderBy.CUSTOM;
        this.config.parameterOrdering = parameterOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withPropertyOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.propertyOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withPropertyOrdering(Comparator<String> propertyOrdering) {
        Validate.notNull(propertyOrdering, (String)"%s must not be null", (Object[])new Object[]{"propertyOrdering"});
        this.config.propertyOrderBy = OrderBy.CUSTOM;
        this.config.propertyOrdering = propertyOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withResponseOrdering(OrderBy orderBy) {
        Validate.notNull((Object)((Object)orderBy), (String)"%s must not be null", (Object[])new Object[]{"orderBy"});
        Validate.isTrue((orderBy != OrderBy.CUSTOM ? 1 : 0) != 0, (String)"You must provide a custom comparator if orderBy == OrderBy.CUSTOM", (Object[])new Object[0]);
        this.config.responseOrderBy = orderBy;
        return this;
    }

    public Swagger2MarkupConfigBuilder withResponseOrdering(Comparator<String> responseOrdering) {
        Validate.notNull(responseOrdering, (String)"%s must not be null", (Object[])new Object[]{"responseOrdering"});
        this.config.responseOrderBy = OrderBy.CUSTOM;
        this.config.responseOrdering = responseOrdering;
        return this;
    }

    public Swagger2MarkupConfigBuilder withInterDocumentCrossReferences(String prefix) {
        Validate.notNull((Object)prefix, (String)"%s must not be null", (Object[])new Object[]{"prefix"});
        this.config.interDocumentCrossReferencesEnabled = true;
        this.config.interDocumentCrossReferencesPrefix = prefix;
        return this;
    }

    public Swagger2MarkupConfigBuilder withInterDocumentCrossReferences() {
        this.config.interDocumentCrossReferencesEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withFlatBody() {
        this.config.flatBodyEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withoutPathSecuritySection() {
        this.config.pathSecuritySectionEnabled = false;
        return this;
    }

    public Swagger2MarkupConfigBuilder withBasePathPrefix() {
        this.config.basePathPrefixEnabled = true;
        return this;
    }

    public Swagger2MarkupConfigBuilder withAnchorPrefix(String anchorPrefix) {
        Validate.notNull((Object)anchorPrefix, (String)"%s must not be null", (Object[])new Object[]{"anchorPrefix"});
        this.config.anchorPrefix = anchorPrefix;
        return this;
    }

    public Swagger2MarkupConfigBuilder withPageBreaks(List<PageBreakLocations> locations) {
        Validate.notNull(locations, (String)"%s must not be null", (Object[])new Object[]{"locations"});
        this.config.pageBreakLocations = locations;
        return this;
    }

    public Swagger2MarkupConfigBuilder withLineSeparator(LineSeparator lineSeparator) {
        Validate.notNull((Object)lineSeparator, (String)"%s must no be null", (Object[])new Object[]{"lineSeparator"});
        this.config.lineSeparator = lineSeparator;
        return this;
    }

    static class DefaultSwagger2MarkupConfig
    implements Swagger2MarkupConfig {
        private MarkupLanguage markupLanguage;
        private MarkupLanguage swaggerMarkupLanguage;
        private boolean generatedExamplesEnabled;
        private boolean basePathPrefixEnabled;
        private boolean separatedDefinitionsEnabled;
        private boolean separatedOperationsEnabled;
        private GroupBy pathsGroupedBy;
        private Language outputLanguage;
        private boolean inlineSchemaEnabled;
        private OrderBy tagOrderBy;
        private Comparator<String> tagOrdering;
        private OrderBy operationOrderBy;
        private Comparator<PathOperation> operationOrdering;
        private OrderBy definitionOrderBy;
        private Comparator<String> definitionOrdering;
        private OrderBy parameterOrderBy;
        private Comparator<Parameter> parameterOrdering;
        private OrderBy propertyOrderBy;
        private Comparator<String> propertyOrdering;
        private OrderBy responseOrderBy;
        private Comparator<String> responseOrdering;
        private boolean interDocumentCrossReferencesEnabled;
        private String interDocumentCrossReferencesPrefix;
        private boolean flatBodyEnabled;
        private boolean pathSecuritySectionEnabled;
        private String anchorPrefix;
        private LineSeparator lineSeparator;
        private String overviewDocument;
        private String pathsDocument;
        private String definitionsDocument;
        private String securityDocument;
        private String separatedOperationsFolder;
        private String separatedDefinitionsFolder;
        private Character listDelimiter;
        private boolean listDelimiterEnabled;
        private List<PageBreakLocations> pageBreakLocations;
        private Pattern headerPattern;
        private Swagger2MarkupProperties extensionsProperties;

        DefaultSwagger2MarkupConfig() {
        }

        @Override
        public MarkupLanguage getMarkupLanguage() {
            return this.markupLanguage;
        }

        @Override
        public MarkupLanguage getSwaggerMarkupLanguage() {
            return this.swaggerMarkupLanguage;
        }

        @Override
        public boolean isGeneratedExamplesEnabled() {
            return this.generatedExamplesEnabled;
        }

        @Override
        public boolean isSeparatedDefinitionsEnabled() {
            return this.separatedDefinitionsEnabled;
        }

        @Override
        public boolean isSeparatedOperationsEnabled() {
            return this.separatedOperationsEnabled;
        }

        @Override
        public GroupBy getPathsGroupedBy() {
            return this.pathsGroupedBy;
        }

        @Override
        public Language getOutputLanguage() {
            return this.outputLanguage;
        }

        @Override
        public boolean isInlineSchemaEnabled() {
            return this.inlineSchemaEnabled;
        }

        @Override
        public OrderBy getTagOrderBy() {
            return this.tagOrderBy;
        }

        @Override
        public Pattern getHeaderPattern() {
            return this.headerPattern;
        }

        @Override
        public Comparator<String> getTagOrdering() {
            return this.tagOrdering;
        }

        @Override
        public OrderBy getOperationOrderBy() {
            return this.operationOrderBy;
        }

        @Override
        public Comparator<PathOperation> getOperationOrdering() {
            return this.operationOrdering;
        }

        @Override
        public OrderBy getDefinitionOrderBy() {
            return this.definitionOrderBy;
        }

        @Override
        public Comparator<String> getDefinitionOrdering() {
            return this.definitionOrdering;
        }

        @Override
        public OrderBy getParameterOrderBy() {
            return this.parameterOrderBy;
        }

        @Override
        public Comparator<Parameter> getParameterOrdering() {
            return this.parameterOrdering;
        }

        @Override
        public OrderBy getPropertyOrderBy() {
            return this.propertyOrderBy;
        }

        @Override
        public Comparator<String> getPropertyOrdering() {
            return this.propertyOrdering;
        }

        @Override
        public OrderBy getResponseOrderBy() {
            return this.responseOrderBy;
        }

        @Override
        public Comparator<String> getResponseOrdering() {
            return this.responseOrdering;
        }

        @Override
        public boolean isInterDocumentCrossReferencesEnabled() {
            return this.interDocumentCrossReferencesEnabled;
        }

        @Override
        public String getInterDocumentCrossReferencesPrefix() {
            return this.interDocumentCrossReferencesPrefix;
        }

        @Override
        public boolean isFlatBodyEnabled() {
            return this.flatBodyEnabled;
        }

        @Override
        public boolean isPathSecuritySectionEnabled() {
            return this.pathSecuritySectionEnabled;
        }

        @Override
        public String getAnchorPrefix() {
            return this.anchorPrefix;
        }

        @Override
        public String getOverviewDocument() {
            return this.overviewDocument;
        }

        @Override
        public String getPathsDocument() {
            return this.pathsDocument;
        }

        @Override
        public String getDefinitionsDocument() {
            return this.definitionsDocument;
        }

        @Override
        public String getSecurityDocument() {
            return this.securityDocument;
        }

        @Override
        public String getSeparatedOperationsFolder() {
            return this.separatedOperationsFolder;
        }

        @Override
        public String getSeparatedDefinitionsFolder() {
            return this.separatedDefinitionsFolder;
        }

        @Override
        public LineSeparator getLineSeparator() {
            return this.lineSeparator;
        }

        @Override
        public Character getListDelimiter() {
            return this.listDelimiter;
        }

        @Override
        public boolean isListDelimiterEnabled() {
            return this.listDelimiterEnabled;
        }

        @Override
        public Swagger2MarkupProperties getExtensionsProperties() {
            return this.extensionsProperties;
        }

        @Override
        public boolean isBasePathPrefixEnabled() {
            return this.basePathPrefixEnabled;
        }

        @Override
        public List<PageBreakLocations> getPageBreakLocations() {
            return this.pageBreakLocations;
        }
    }
}

