/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.channel.AbstractConnectionEvent;
import io.reactivex.netty.channel.NewRxConnectionEvent;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.ConnectionReuseEvent;
import io.reactivex.netty.client.PooledConnectionReleasedEvent;
import io.reactivex.netty.metrics.Clock;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.http.UnicastContentSubject;
import io.reactivex.netty.protocol.http.client.HttpClientMetricsEvent;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.util.MultipleFutureListener;
import java.io.IOException;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;

public class ClientRequestResponseConverter
extends ChannelDuplexHandler {
    public static final AttributeKey<Long> KEEP_ALIVE_TIMEOUT_MILLIS_ATTR = AttributeKey.valueOf((String)"rxnetty_http_conn_keep_alive_timeout_millis");
    public static final AttributeKey<Boolean> DISCARD_CONNECTION = AttributeKey.valueOf((String)"rxnetty_http_discard_connection");
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    private ResponseState responseState;
    public static final IOException CONN_CLOSE_BEFORE_RESPONSE = new IOException("Connection closed by peer before sending a response.");

    public ClientRequestResponseConverter(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.eventsSubject = eventsSubject;
        this.responseState = new ResponseState();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> recievedMsgClass = msg.getClass();
        ResponseState stateToUse = this.responseState;
        if (HttpResponse.class.isAssignableFrom(recievedMsgClass)) {
            stateToUse.responseReceiveStartTimeMillis = Clock.newStartTimeMillis();
            this.eventsSubject.onEvent(HttpClientMetricsEvent.RESPONSE_HEADER_RECEIVED);
            HttpResponse response = (HttpResponse)msg;
            DecoderResult decoderResult = response.getDecoderResult();
            if (decoderResult.isFailure()) {
                ctx.channel().attr(DISCARD_CONNECTION).set((Object)true);
                stateToUse.sendOnError(decoderResult.cause());
            } else {
                HttpClientResponse rxResponse = new HttpClientResponse(response, stateToUse.contentSubject);
                Long keepAliveTimeoutSeconds = rxResponse.getKeepAliveTimeoutSeconds();
                if (null != keepAliveTimeoutSeconds) {
                    ctx.channel().attr(KEEP_ALIVE_TIMEOUT_MILLIS_ATTR).set((Object)(keepAliveTimeoutSeconds * 1000L));
                }
                if (!rxResponse.getHeaders().isKeepAlive()) {
                    ctx.channel().attr(DISCARD_CONNECTION).set((Object)true);
                }
                super.channelRead(ctx, rxResponse);
            }
        }
        if (HttpContent.class.isAssignableFrom(recievedMsgClass)) {
            this.eventsSubject.onEvent(HttpClientMetricsEvent.RESPONSE_CONTENT_RECEIVED);
            ByteBuf content = ((ByteBufHolder)msg).content();
            if (LastHttpContent.class.isAssignableFrom(recievedMsgClass)) {
                stateToUse.responseReceiveComplete();
                if (content.isReadable()) {
                    ClientRequestResponseConverter.invokeContentOnNext(content, stateToUse);
                } else {
                    ReferenceCountUtil.release((Object)content);
                }
                stateToUse.sendOnComplete();
            } else {
                ClientRequestResponseConverter.invokeContentOnNext(content, stateToUse);
            }
        } else if (!HttpResponse.class.isAssignableFrom(recievedMsgClass)) {
            ClientRequestResponseConverter.invokeContentOnNext(msg, stateToUse);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Class<?> recievedMsgClass = msg.getClass();
        ResponseState stateToUse = this.responseState;
        if (HttpClientRequest.class.isAssignableFrom(recievedMsgClass)) {
            HttpClientRequest rxRequest = (HttpClientRequest)msg;
            MultipleFutureListener allWritesListener = new MultipleFutureListener(promise);
            Object contentSource = null;
            switch (rxRequest.getContentSourceType()) {
                case Raw: {
                    if (!rxRequest.getHeaders().isContentLengthSet()) {
                        rxRequest.getHeaders().add("Transfer-Encoding", (Object)"chunked");
                    }
                    contentSource = rxRequest.getRawContentSource();
                    break;
                }
                case Typed: {
                    if (!rxRequest.getHeaders().isContentLengthSet()) {
                        rxRequest.getHeaders().add("Transfer-Encoding", (Object)"chunked");
                    }
                    contentSource = rxRequest.getContentSource();
                    break;
                }
                case Absent: {
                    if (rxRequest.getHeaders().isContentLengthSet() || rxRequest.getMethod() == HttpMethod.GET) break;
                    rxRequest.getHeaders().set("Content-Length", (Object)0);
                }
            }
            this.writeHttpHeaders(ctx, rxRequest, allWritesListener);
            if (null != contentSource) {
                if (!rxRequest.getHeaders().isContentLengthSet()) {
                    rxRequest.getHeaders().add("Transfer-Encoding", (Object)"chunked");
                }
                this.writeContent(ctx, allWritesListener, (Observable<?>)contentSource, promise, rxRequest, stateToUse);
            } else {
                this.writeLastHttpContent(ctx, allWritesListener, rxRequest, stateToUse);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    protected void writeLastHttpContent(ChannelHandlerContext ctx, MultipleFutureListener allWritesListener, HttpClientRequest<?> rxRequest, final ResponseState responseState) {
        this.writeAContentChunk(ctx, allWritesListener, new DefaultLastHttpContent()).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                responseState.nowWaitingForResponse();
            }
        });
        rxRequest.onWriteComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectionReuseEvent) {
            this.responseState = new ResponseState();
            this.responseState.setConnection((AbstractConnectionEvent)evt);
        } else if (evt instanceof NewRxConnectionEvent) {
            this.responseState.setConnection((AbstractConnectionEvent)evt);
        } else if (evt instanceof PooledConnectionReleasedEvent) {
            this.responseState.onConnectionClose();
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.responseState.onConnectionClose();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.responseState.sendOnError(cause);
        super.exceptionCaught(ctx, cause);
    }

    private static void invokeContentOnNext(Object nextObject, ResponseState stateToUse) {
        try {
            stateToUse.contentSubject.onNext(nextObject);
        }
        catch (ClassCastException e) {
            stateToUse.contentSubject.onError(e);
        }
        finally {
            ReferenceCountUtil.release((Object)nextObject);
        }
    }

    private void writeHttpHeaders(ChannelHandlerContext ctx, HttpClientRequest<?> rxRequest, MultipleFutureListener allWritesListener) {
        long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(HttpClientMetricsEvent.REQUEST_HEADERS_WRITE_START);
        ChannelFuture writeFuture = ctx.write((Object)rxRequest.getNettyRequest());
        this.addWriteCompleteEvents(writeFuture, startTimeMillis, HttpClientMetricsEvent.REQUEST_HEADERS_WRITE_SUCCESS, HttpClientMetricsEvent.REQUEST_HEADERS_WRITE_FAILED);
        allWritesListener.listen(writeFuture);
    }

    private void writeContent(final ChannelHandlerContext ctx, final MultipleFutureListener allWritesListener, Observable<?> contentSource, final ChannelPromise promise, final HttpClientRequest<?> rxRequest, final ResponseState responseState) {
        contentSource.subscribe((Subscriber)new Subscriber<Object>(){

            public void onCompleted() {
                ClientRequestResponseConverter.this.writeLastHttpContent(ctx, allWritesListener, rxRequest, responseState);
            }

            public void onError(Throwable e) {
                ClientRequestResponseConverter.this.eventsSubject.onEvent(HttpClientMetricsEvent.REQUEST_CONTENT_SOURCE_ERROR, e);
                promise.tryFailure(e);
                rxRequest.onWriteComplete();
            }

            public void onNext(Object chunk) {
                ClientRequestResponseConverter.this.writeAContentChunk(ctx, allWritesListener, chunk);
            }
        });
    }

    private ChannelFuture writeAContentChunk(ChannelHandlerContext ctx, MultipleFutureListener allWritesListener, Object chunk) {
        this.eventsSubject.onEvent(HttpClientMetricsEvent.REQUEST_CONTENT_WRITE_START);
        long startTimeMillis = Clock.newStartTimeMillis();
        ChannelFuture writeFuture = ctx.write(chunk);
        this.addWriteCompleteEvents(writeFuture, startTimeMillis, HttpClientMetricsEvent.REQUEST_CONTENT_WRITE_SUCCESS, HttpClientMetricsEvent.REQUEST_CONTENT_WRITE_FAILED);
        allWritesListener.listen(writeFuture);
        return writeFuture;
    }

    private void addWriteCompleteEvents(ChannelFuture future, final long startTimeMillis, final HttpClientMetricsEvent<HttpClientMetricsEvent.EventType> successEvent, final HttpClientMetricsEvent<HttpClientMetricsEvent.EventType> failureEvent) {
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ClientRequestResponseConverter.this.eventsSubject.onEvent(successEvent, Clock.onEndMillis(startTimeMillis));
                } else {
                    ClientRequestResponseConverter.this.eventsSubject.onEvent(failureEvent, Clock.onEndMillis(startTimeMillis), future.cause());
                }
            }
        });
    }

    private final class ResponseState {
        private ResponseStateProcessingStage stage = ResponseStateProcessingStage.Created;
        private final UnicastContentSubject contentSubject;
        private Observer connInputObsrvr;
        private ObservableConnection connection;
        private long responseReceiveStartTimeMillis;

        private ResponseState() {
            this.contentSubject = UnicastContentSubject.createWithoutNoSubscriptionTimeout(new Action0(){

                public void call() {
                    if (ResponseStateProcessingStage.Finished != ResponseState.this.stage && null != ResponseState.this.connection) {
                        if (ResponseStateProcessingStage.WaitingForResponse == ResponseState.this.stage) {
                            ResponseState.this.connection.getChannel().attr(DISCARD_CONNECTION).set((Object)true);
                        }
                        ResponseState.this.connection.close();
                    }
                }
            });
        }

        private void sendOnError(Throwable error) {
            this.responseReceiveComplete();
            ClientRequestResponseConverter.this.eventsSubject.onEvent(HttpClientMetricsEvent.RESPONSE_FAILED, Clock.onEndMillis(this.responseReceiveStartTimeMillis));
            this.contentSubject.onError(error);
            this.connInputObsrvr.onError(error);
            this.connection.close();
        }

        private void sendOnComplete() {
            ClientRequestResponseConverter.this.eventsSubject.onEvent(HttpClientMetricsEvent.RESPONSE_RECEIVE_COMPLETE, Clock.onEndMillis(this.responseReceiveStartTimeMillis));
            this.connection.close();
            this.contentSubject.onCompleted();
            this.connInputObsrvr.onCompleted();
        }

        private void setConnection(AbstractConnectionEvent<?> connectionEvent) {
            this.connection = connectionEvent.getConnection();
            this.connInputObsrvr = connectionEvent.getConnectedObserver();
        }

        private void nowWaitingForResponse() {
            this.stage = ResponseStateProcessingStage.WaitingForResponse;
        }

        private void responseReceiveComplete() {
            this.stage = ResponseStateProcessingStage.ResponseReceived;
        }

        private void onConnectionClose() {
            if (ResponseStateProcessingStage.WaitingForResponse == this.stage) {
                if (null != this.connection) {
                    this.connection.getChannel().attr(DISCARD_CONNECTION).set((Object)true);
                }
                if (null != this.connInputObsrvr) {
                    this.connInputObsrvr.onError((Throwable)CONN_CLOSE_BEFORE_RESPONSE);
                }
            }
            this.stage = ResponseStateProcessingStage.Finished;
        }
    }

    private static enum ResponseStateProcessingStage {
        Created,
        WaitingForResponse,
        ResponseReceived,
        Finished;

    }
}

