/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.spi;

import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.AbstractExtension;
import io.github.swagger2markup.spi.ContentContext;
import io.swagger.models.Model;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class DefinitionsDocumentExtension
extends AbstractExtension {
    public abstract void apply(Context var1);

    protected int levelOffset(Context context) throws RuntimeException {
        int levelOffset;
        switch (context.position) {
            case DOCUMENT_BEFORE: 
            case DOCUMENT_AFTER: {
                levelOffset = 0;
                break;
            }
            case DOCUMENT_BEGIN: 
            case DOCUMENT_END: 
            case DEFINITION_BEFORE: 
            case DEFINITION_AFTER: {
                levelOffset = 1;
                break;
            }
            case DEFINITION_BEGIN: 
            case DEFINITION_END: {
                levelOffset = 2;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown position '%s'", new Object[]{context.position}));
            }
        }
        return levelOffset;
    }

    public static class Context
    extends ContentContext {
        private Position position;
        private String definitionName;
        private Model model;

        public Context(Position position, MarkupDocBuilder docBuilder) {
            super(docBuilder);
            Validate.inclusiveBetween((Object)((Object)Position.DOCUMENT_BEFORE), (Object)((Object)Position.DOCUMENT_AFTER), (Comparable)((Object)position));
            this.position = position;
        }

        public Context(Position position, MarkupDocBuilder docBuilder, String definitionName, Model model) {
            super(docBuilder);
            Validate.inclusiveBetween((Object)((Object)Position.DEFINITION_BEFORE), (Object)((Object)Position.DEFINITION_AFTER), (Comparable)((Object)position));
            Validate.notNull((Object)definitionName);
            Validate.notNull((Object)model);
            this.position = position;
            this.definitionName = definitionName;
            this.model = model;
        }

        public Position getPosition() {
            return this.position;
        }

        public Optional<String> getDefinitionName() {
            return Optional.ofNullable(this.definitionName);
        }

        public Optional<Model> getModel() {
            return Optional.ofNullable(this.model);
        }
    }

    public static enum Position {
        DOCUMENT_BEFORE,
        DOCUMENT_BEGIN,
        DOCUMENT_END,
        DOCUMENT_AFTER,
        DEFINITION_BEFORE,
        DEFINITION_BEGIN,
        DEFINITION_END,
        DEFINITION_AFTER;

    }
}

