/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.nio.charset.Charset;

public class StringMessageConfigurator
implements PipelineConfigurator<String, String> {
    private final Charset inputCharset;
    private final Charset outputCharset;

    public StringMessageConfigurator() {
        this(Charset.defaultCharset(), Charset.defaultCharset());
    }

    public StringMessageConfigurator(Charset inputCharset, Charset outputCharset) {
        this.inputCharset = inputCharset;
        this.outputCharset = outputCharset;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new StringDecoder(this.outputCharset)}).addLast(new ChannelHandler[]{new StringEncoder(this.inputCharset)});
    }
}

