/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.spectator.api.Id;
import java.util.concurrent.atomic.AtomicLong;

public class MaxGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
SpectatorMonitor {
    private final MonitorConfig baseConfig;
    private final StepLong max;
    private final SpectatorContext.LazyGauge spectatorGauge;

    public MaxGauge(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    MaxGauge(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.baseConfig = config;
        this.max = new StepLong(0L, clock);
        this.spectatorGauge = SpectatorContext.maxGauge(config);
    }

    private void updateMax(int idx, long v) {
        AtomicLong current = this.max.getCurrent(idx);
        long m = current.get();
        while (v > m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    public void update(long v) {
        this.spectatorGauge.set(v);
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updateMax(i, v);
        }
    }

    @Override
    public Long getValue(int nth) {
        return this.max.poll(nth);
    }

    public long getCurrentValue(int nth) {
        return this.max.getCurrent(nth).get();
    }

    @Override
    public void initializeSpectator(TagList tags) {
        Id id = SpectatorContext.createId(this.baseConfig.withAdditionalTags(tags));
        this.spectatorGauge.setId(id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MaxGauge)) {
            return false;
        }
        MaxGauge m = (MaxGauge)obj;
        return this.config.equals(m.getConfig()) && this.getValue(0).equals(m.getValue(0));
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.getValue(0).hashCode();
        return result;
    }

    public String toString() {
        return "MaxGauge{config=" + this.config + ", max=" + this.max + '}';
    }
}

