/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.strategy.properties.HystrixDynamicProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class HystrixArchaiusHelper {
    HystrixArchaiusHelper() {
    }

    static boolean isArchaiusV1Available() {
        return LazyHolder.loadCascadedPropertiesFromResources != null;
    }

    static void loadCascadedPropertiesFromResources(String name) {
        if (HystrixArchaiusHelper.isArchaiusV1Available()) {
            try {
                LazyHolder.loadCascadedPropertiesFromResources.invoke(null, name);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    static HystrixDynamicProperties createArchaiusDynamicProperties() {
        if (HystrixArchaiusHelper.isArchaiusV1Available()) {
            HystrixArchaiusHelper.loadCascadedPropertiesFromResources("hystrix-plugins");
            try {
                Class<?> defaultProperties = Class.forName("com.netflix.hystrix.strategy.properties.archaius.HystrixDynamicPropertiesArchaius");
                return (HystrixDynamicProperties)defaultProperties.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static class LazyHolder {
        private static final Method loadCascadedPropertiesFromResources;
        private static final String CONFIG_MANAGER_CLASS = "com.netflix.config.ConfigurationManager";

        private LazyHolder() {
        }

        static {
            Method load = null;
            try {
                Class<?> configManager = Class.forName(CONFIG_MANAGER_CLASS);
                load = configManager.getMethod("loadCascadedPropertiesFromResources", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadCascadedPropertiesFromResources = load;
        }
    }
}

