/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.DoubleGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.tag.TagList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicGauge
implements CompositeMonitor<Long>,
SpectatorMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicGauge.class);
    private static final String DEFAULT_EXPIRATION = "15";
    private static final String DEFAULT_EXPIRATION_UNIT = "MINUTES";
    private static final String CLASS_NAME = DynamicGauge.class.getCanonicalName();
    private static final String EXPIRATION_PROP = CLASS_NAME + ".expiration";
    private static final String EXPIRATION_PROP_UNIT = CLASS_NAME + ".expirationUnit";
    private static final String INTERNAL_ID = "servoGauges";
    private static final String CACHE_MONITOR_ID = "servoGaugesCache";
    private static final MonitorConfig BASE_CONFIG = new MonitorConfig.Builder("servoGauges").build();
    private static final DynamicGauge INSTANCE = new DynamicGauge();
    private final LoadingCache<MonitorConfig, DoubleGauge> gauges;
    private final CompositeMonitor<?> cacheMonitor;

    private DynamicGauge() {
        String expiration = System.getProperty(EXPIRATION_PROP, DEFAULT_EXPIRATION);
        String expirationUnit = System.getProperty(EXPIRATION_PROP_UNIT, DEFAULT_EXPIRATION_UNIT);
        long expirationValue = Long.parseLong(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        this.gauges = CacheBuilder.newBuilder().expireAfterAccess(expirationValue, expirationUnitValue).build((CacheLoader)new CacheLoader<MonitorConfig, DoubleGauge>(){

            public DoubleGauge load(MonitorConfig config) throws Exception {
                return new DoubleGauge(config);
            }
        });
        this.cacheMonitor = Monitors.newCacheMonitor(CACHE_MONITOR_ID, this.gauges);
        DefaultMonitorRegistry.getInstance().register(this);
    }

    @Override
    public void initializeSpectator(TagList tags) {
    }

    public static void set(MonitorConfig config, double value) {
        INSTANCE.get(config).set(value);
    }

    public static void set(String name, double value) {
        DynamicGauge.set(MonitorConfig.builder(name).build(), value);
    }

    public static void set(String name, TagList list, double value) {
        MonitorConfig config = MonitorConfig.builder(name).withTags(list).build();
        DynamicGauge.set(config, value);
    }

    private DoubleGauge get(MonitorConfig config) {
        try {
            return (DoubleGauge)this.gauges.get((Object)config);
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to get a gauge for {}: {}", (Object)config, (Object)e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        ConcurrentMap gaugesMap = this.gauges.asMap();
        return ImmutableList.copyOf(gaugesMap.values());
    }

    @Override
    public Long getValue() {
        return this.gauges.asMap().size();
    }

    @Override
    public Long getValue(int pollerIndex) {
        return this.getValue();
    }

    @Override
    public MonitorConfig getConfig() {
        return BASE_CONFIG;
    }

    public String toString() {
        ConcurrentMap map = this.gauges.asMap();
        return "DynamicGauge{baseConfig=" + BASE_CONFIG + ", totalGauges=" + map.size() + ", gauges=" + map + '}';
    }
}

