/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.ribbon.RequestTemplate;
import com.netflix.ribbon.RibbonRequest;
import com.netflix.ribbon.http.HttpRequest;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.template.ParsedTemplate;
import com.netflix.ribbon.template.TemplateParser;
import com.netflix.ribbon.template.TemplateParsingException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;

public class HttpRequestBuilder<T>
extends RequestTemplate.RequestBuilder<T> {
    private final HttpRequestTemplate<T> requestTemplate;
    private final Map<String, Object> vars;
    private final ParsedTemplate parsedUriTemplate;
    private Observable rawContentSource;
    private ContentTransformer contentTransformer;
    private Map<String, String> extraHeaders = new HashMap<String, String>();
    private static final ContentTransformer<ByteBuf> passThroughContentTransformer = new ContentTransformer<ByteBuf>(){

        public ByteBuf call(ByteBuf t1, ByteBufAllocator t2) {
            return t1;
        }
    };

    HttpRequestBuilder(HttpRequestTemplate<T> requestTemplate) {
        this.requestTemplate = requestTemplate;
        this.parsedUriTemplate = requestTemplate.uriTemplate();
        this.vars = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public HttpRequestBuilder<T> withRequestProperty(String key, Object value) {
        this.vars.put(key, value);
        return this;
    }

    public <S> HttpRequestBuilder<T> withRawContentSource(Observable<S> raw, ContentTransformer<S> transformer) {
        this.rawContentSource = raw;
        this.contentTransformer = transformer;
        return this;
    }

    public HttpRequestBuilder<T> withContent(Observable<ByteBuf> content) {
        this.rawContentSource = content;
        this.contentTransformer = passThroughContentTransformer;
        return this;
    }

    public HttpRequestBuilder<T> withHeader(String key, String value) {
        this.extraHeaders.put(key, value);
        return this;
    }

    @Override
    public RibbonRequest<T> build() {
        if (this.requestTemplate.uriTemplate() == null) {
            throw new IllegalArgumentException("URI template is not defined");
        }
        if (this.requestTemplate.method() == null) {
            throw new IllegalArgumentException("HTTP method is not defined");
        }
        try {
            return new HttpRequest(this);
        }
        catch (TemplateParsingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    HttpClientRequest<ByteBuf> createClientRequest() {
        String uri;
        try {
            uri = TemplateParser.toData(this.vars, this.parsedUriTemplate.getTemplate(), this.parsedUriTemplate.getParsed());
        }
        catch (TemplateParsingException e) {
            throw new HystrixBadRequestException("Problem parsing the URI template", (Throwable)e);
        }
        HttpClientRequest request = HttpClientRequest.create((HttpMethod)this.requestTemplate.method(), (String)uri);
        for (Map.Entry entry : this.requestTemplate.getHeaders().entries()) {
            request.withHeader((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : this.extraHeaders.entrySet()) {
            request.withHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.rawContentSource != null) {
            request.withRawContentSource(this.rawContentSource, this.contentTransformer);
        }
        return request;
    }

    String hystrixCacheKey() throws TemplateParsingException {
        ParsedTemplate keyTemplate = this.requestTemplate.hystrixCacheKeyTemplate();
        if (keyTemplate == null || keyTemplate.getTemplate() == null || keyTemplate.getTemplate().length() == 0) {
            return null;
        }
        return TemplateParser.toData(this.vars, this.requestTemplate.hystrixCacheKeyTemplate());
    }

    Map<String, Object> requestProperties() {
        return this.vars;
    }

    HttpRequestTemplate.CacheProviderWithKeyTemplate<T> cacheProvider() {
        return this.requestTemplate.cacheProvider();
    }

    HttpRequestTemplate<T> template() {
        return this.requestTemplate;
    }
}

