/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.bootstrap.Bootstrap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.udp.UdpServer;
import reactor.netty.udp.UdpServerOperator;

final class UdpServerDoOn
extends UdpServerOperator
implements ConnectionObserver {
    final Consumer<? super Bootstrap> onBind;
    final Consumer<? super Connection> onBound;
    final Consumer<? super Connection> onUnbound;

    UdpServerDoOn(UdpServer server, @Nullable Consumer<? super Bootstrap> onBind, @Nullable Consumer<? super Connection> onBound, @Nullable Consumer<? super Connection> onUnbound) {
        super(server);
        this.onBind = onBind;
        this.onBound = onBound;
        this.onUnbound = onUnbound;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(b);
        BootstrapHandlers.connectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public Mono<? extends Connection> bind(Bootstrap b) {
        if (this.onBind != null) {
            return this.source.bind(b).doOnSubscribe(s -> this.onBind.accept((Bootstrap)b));
        }
        return this.source.bind(b);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (this.onBound != null && newState == ConnectionObserver.State.CONFIGURED) {
            this.onBound.accept(connection);
            return;
        }
        if (this.onUnbound != null && newState == ConnectionObserver.State.DISCONNECTING) {
            connection.onDispose(() -> this.onUnbound.accept(connection));
        }
    }
}

