/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo.tcp;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Timer;
import io.reactivex.netty.metrics.ServerMetricEventsListener;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.servo.RefCountingMonitor;
import io.reactivex.netty.servo.ServoUtils;
import java.util.concurrent.TimeUnit;

public class TcpServerListener<T extends ServerMetricsEvent<?>>
extends ServerMetricEventsListener<T> {
    private final LongGauge liveConnections;
    private final LongGauge inflightConnections;
    private final Counter failedConnections;
    private final Timer connectionProcessingTimes;
    private final LongGauge pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final Timer connectionCloseTimes;
    private final LongGauge pendingWrites;
    private final LongGauge pendingFlushes;
    private final Counter bytesWritten;
    private final Timer writeTimes;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;
    private final Timer flushTimes;
    private final RefCountingMonitor refCounter;

    protected TcpServerListener(String monitorId) {
        this.refCounter = new RefCountingMonitor(monitorId);
        this.liveConnections = ServoUtils.newLongGauge("liveConnections");
        this.inflightConnections = ServoUtils.newLongGauge("inflightConnections");
        this.pendingConnectionClose = ServoUtils.newLongGauge("pendingConnectionClose");
        this.failedConnectionClose = Monitors.newCounter((String)"failedConnectionClose");
        this.failedConnections = Monitors.newCounter((String)"failedConnections");
        this.connectionProcessingTimes = Monitors.newTimer((String)"connectionProcessingTimes");
        this.connectionCloseTimes = Monitors.newTimer((String)"connectionCloseTimes");
        this.pendingWrites = ServoUtils.newLongGauge("pendingWrites");
        this.pendingFlushes = ServoUtils.newLongGauge("pendingFlushes");
        this.bytesWritten = Monitors.newCounter((String)"bytesWritten");
        this.writeTimes = Monitors.newTimer((String)"writeTimes");
        this.bytesRead = Monitors.newCounter((String)"bytesRead");
        this.failedWrites = Monitors.newCounter((String)"failedWrites");
        this.failedFlushes = Monitors.newCounter((String)"failedFlushes");
        this.flushTimes = Monitors.newTimer((String)"flushTimes");
    }

    protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.inflightConnections);
        this.failedConnections.increment();
    }

    protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.inflightConnections);
        this.connectionProcessingTimes.record(duration, timeUnit);
    }

    protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        ServoUtils.incrementLongGauge(this.inflightConnections);
    }

    protected void onConnectionCloseStart() {
        ServoUtils.incrementLongGauge(this.pendingConnectionClose);
    }

    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.liveConnections);
        ServoUtils.decrementLongGauge(this.pendingConnectionClose);
        this.connectionCloseTimes.record(duration, timeUnit);
    }

    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.liveConnections);
        ServoUtils.decrementLongGauge(this.pendingConnectionClose);
        this.connectionCloseTimes.record(duration, timeUnit);
        this.failedConnectionClose.increment();
    }

    protected void onNewClientConnected() {
        ServoUtils.incrementLongGauge(this.liveConnections);
    }

    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingFlushes);
        this.failedFlushes.increment();
    }

    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.pendingFlushes);
        this.flushTimes.record(duration, timeUnit);
    }

    protected void onFlushStart() {
        ServoUtils.incrementLongGauge(this.pendingFlushes);
    }

    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingWrites);
        this.failedWrites.increment();
    }

    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        ServoUtils.decrementLongGauge(this.pendingWrites);
        this.bytesWritten.increment(bytesWritten);
        this.writeTimes.record(duration, timeUnit);
    }

    protected void onWriteStart() {
        ServoUtils.incrementLongGauge(this.pendingWrites);
    }

    public void onCompleted() {
        this.refCounter.onCompleted((Object)this);
    }

    public void onSubscribe() {
        this.refCounter.onSubscribe((Object)this);
    }

    public static TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>>(monitorId);
    }

    public long getLiveConnections() {
        return ((Number)this.liveConnections.getValue()).longValue();
    }

    public long getInflightConnections() {
        return ((Number)this.inflightConnections.getValue()).longValue();
    }

    public long getFailedConnections() {
        return ((Number)this.failedConnections.getValue()).longValue();
    }

    public Timer getConnectionProcessingTimes() {
        return this.connectionProcessingTimes;
    }

    public long getPendingWrites() {
        return ((Number)this.pendingWrites.getValue()).longValue();
    }

    public long getPendingFlushes() {
        return ((Number)this.pendingFlushes.getValue()).longValue();
    }

    public long getBytesWritten() {
        return ((Number)this.bytesWritten.getValue()).longValue();
    }

    public Timer getWriteTimes() {
        return this.writeTimes;
    }

    public long getBytesRead() {
        return ((Number)this.bytesRead.getValue()).longValue();
    }

    public long getFailedWrites() {
        return ((Number)this.failedWrites.getValue()).longValue();
    }

    public long getFailedFlushes() {
        return ((Number)this.failedFlushes.getValue()).longValue();
    }

    public Timer getFlushTimes() {
        return this.flushTimes;
    }
}

