/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.internal.Platform;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.HttpCall;
import zipkin2.reporter.okhttp3.RequestBodyMessageEncoder;

public final class OkHttpSender
extends Sender {
    final HttpUrl endpoint;
    final OkHttpClient client;
    final RequestBodyMessageEncoder encoder;
    final Encoding encoding;
    final int messageMaxBytes;
    final int maxRequests;
    final boolean compressionEnabled;
    volatile boolean closeCalled;

    public static OkHttpSender create(String endpoint) {
        return OkHttpSender.newBuilder().encoding(Encoding.JSON).endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new Builder(new OkHttpClient.Builder());
    }

    OkHttpSender(Builder builder) {
        if (builder.endpoint == null) {
            throw new NullPointerException("endpoint == null");
        }
        this.endpoint = builder.endpoint;
        this.encoding = builder.encoding;
        switch (this.encoding) {
            case JSON: {
                this.encoder = RequestBodyMessageEncoder.JSON;
                break;
            }
            case THRIFT: {
                this.encoder = RequestBodyMessageEncoder.THRIFT;
                break;
            }
            case PROTO3: {
                this.encoder = RequestBodyMessageEncoder.PROTO3;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding.name());
            }
        }
        this.maxRequests = builder.maxRequests;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.compressionEnabled = builder.compressionEnabled;
        Dispatcher dispatcher = OkHttpSender.newDispatcher(this.maxRequests);
        this.client = builder.clientBuilder().build().newBuilder().dispatcher(dispatcher).build();
    }

    static Dispatcher newDispatcher(int maxRequests) {
        ThreadPoolExecutor dispatchExecutor = new ThreadPoolExecutor(0, maxRequests, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttpSender Dispatcher", (boolean)false));
        Dispatcher dispatcher = new Dispatcher((ExecutorService)dispatchExecutor);
        dispatcher.setMaxRequests(maxRequests);
        dispatcher.setMaxRequestsPerHost(maxRequests);
        return dispatcher;
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding.listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding.listSizeInBytes(encodedSizeInBytes);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        Request request;
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        try {
            request = this.newRequest(this.encoder.encode(encodedSpans));
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
        return new HttpCall(this.client.newCall(request));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckResult check() {
        try {
            Request request = new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"[]")).build();
            try (Response response = this.client.newCall(request).execute();){
                if (response.isSuccessful()) return CheckResult.OK;
                CheckResult checkResult = CheckResult.failed((Throwable)new RuntimeException("check response failed: " + response));
                return checkResult;
            }
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        Dispatcher dispatcher = this.client.dispatcher();
        dispatcher.executorService().shutdown();
        try {
            if (!dispatcher.executorService().awaitTermination(1L, TimeUnit.SECONDS)) {
                dispatcher.cancelAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    Request newRequest(RequestBody body) throws IOException {
        Request.Builder request = new Request.Builder().url(this.endpoint);
        if (this.compressionEnabled) {
            request.addHeader("Content-Encoding", "gzip");
            Buffer gzipped = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)gzipped));
            body.writeTo(gzipSink);
            gzipSink.close();
            body = new BufferRequestBody(body.contentType(), gzipped);
        }
        request.post(body);
        return request.build();
    }

    public final String toString() {
        return "OkHttpSender{" + this.endpoint + "}";
    }

    static final class BufferRequestBody
    extends RequestBody {
        final MediaType contentType;
        final Buffer body;

        BufferRequestBody(MediaType contentType, Buffer body) {
            this.contentType = contentType;
            this.body = body;
        }

        public long contentLength() {
            return this.body.size();
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.body, this.body.size());
        }
    }

    public static final class Builder {
        final OkHttpClient.Builder clientBuilder;
        HttpUrl endpoint;
        Encoding encoding = Encoding.JSON;
        boolean compressionEnabled = true;
        int maxRequests = 64;
        int messageMaxBytes = 0x500000;

        Builder(OkHttpClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
        }

        Builder(OkHttpSender sender) {
            this.clientBuilder = sender.client.newBuilder();
            this.endpoint = sender.endpoint;
            this.maxRequests = sender.client.dispatcher().getMaxRequests();
            this.compressionEnabled = sender.compressionEnabled;
            this.encoding = sender.encoding;
            this.messageMaxBytes = sender.messageMaxBytes;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            HttpUrl parsed = HttpUrl.parse((String)endpoint);
            if (parsed == null) {
                throw new IllegalArgumentException("invalid post url: " + endpoint);
            }
            return this.endpoint(parsed);
        }

        public Builder endpoint(HttpUrl endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder maxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public final Builder connectTimeout(int connectTimeoutMillis) {
            this.clientBuilder.connectTimeout((long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder readTimeout(int readTimeoutMillis) {
            this.clientBuilder.readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder writeTimeout(int writeTimeoutMillis) {
            this.clientBuilder.writeTimeout((long)writeTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public OkHttpClient.Builder clientBuilder() {
            return this.clientBuilder;
        }

        public final OkHttpSender build() {
            return new OkHttpSender(this);
        }
    }
}

