/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTreeNodeImpl<T extends MutableTreeNode<T>>
implements MutableTreeNode<T> {
    private final List<T> children = new ArrayList<T>();
    private final List<T> childrenView = Collections.unmodifiableList(this.children);
    private T parent;

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public List<T> getChildren() {
        return this.childrenView;
    }

    @Override
    public void addChild(int n, T t) {
        Preconditions.checkElementIndex(n, this.children.size() + 1);
        if (t != null) {
            if (t.getParent() == this) {
                return;
            }
            if (t.getParent() != null) {
                TreeUtils.removeChild((MutableTreeNode)t.getParent(), t);
            }
        }
        this.children.add(n, t);
        MutableTreeNodeImpl.setParent(t, this);
    }

    @Override
    public void setChild(int n, T t) {
        Preconditions.checkElementIndex(n, this.children.size());
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.children.get(n);
        if (mutableTreeNode == t) {
            return;
        }
        MutableTreeNodeImpl.setParent(mutableTreeNode, null);
        if (t != null && t.getParent() != this) {
            TreeUtils.removeChild((MutableTreeNode)t.getParent(), t);
        }
        this.children.set(n, t);
        MutableTreeNodeImpl.setParent(t, this);
    }

    @Override
    public T removeChild(int n) {
        Preconditions.checkElementIndex(n, this.children.size());
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.children.remove(n);
        MutableTreeNodeImpl.setParent(mutableTreeNode, null);
        return (T)mutableTreeNode;
    }

    private static <T extends MutableTreeNode<T>> void setParent(T t, MutableTreeNodeImpl<T> mutableTreeNodeImpl) {
        if (t != null) {
            ((MutableTreeNodeImpl)t).parent = mutableTreeNodeImpl;
        }
    }
}

