/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.dns.AddressResolverOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressResolverConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressResolverConfig.class);

    public static AddressResolverOptions getAddressResover(String tag) {
        return AddressResolverConfig.getAddressResover(tag, null);
    }

    public static AddressResolverOptions getAddressResover(String tag, Configuration configSource) {
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        addressResolverOptions.setServers(AddressResolverConfig.getStringListProperty(configSource, AddressResolverOptions.DEFAULT_SERVERS, "addressResolver." + tag + ".servers", "addressResolver.servers"));
        addressResolverOptions.setOptResourceEnabled(AddressResolverConfig.getBooleanProperty(configSource, true, "addressResolver." + tag + ".optResourceEnabled", "addressResolver.optResourceEnabled"));
        addressResolverOptions.setCacheMinTimeToLive(AddressResolverConfig.getPositiveIntProperty(configSource, 0, "addressResolver." + tag + ".cacheMinTimeToLive", "addressResolver.cacheMinTimeToLive"));
        addressResolverOptions.setCacheMaxTimeToLive(AddressResolverConfig.getPositiveIntProperty(configSource, Integer.MAX_VALUE, "addressResolver." + tag + ".cacheMaxTimeToLive", "addressResolver.cacheMaxTimeToLive"));
        addressResolverOptions.setCacheNegativeTimeToLive(AddressResolverConfig.getPositiveIntProperty(configSource, 0, "addressResolver." + tag + ".cacheNegativeTimeToLive", "addressResolver.cacheNegativeTimeToLive"));
        addressResolverOptions.setQueryTimeout((long)AddressResolverConfig.getPositiveIntProperty(configSource, 5000, "addressResolver." + tag + ".queryTimeout", "addressResolver.queryTimeout"));
        addressResolverOptions.setMaxQueries(AddressResolverConfig.getPositiveIntProperty(configSource, 4, "addressResolver." + tag + ".maxQueries", "addressResolver.maxQueries"));
        addressResolverOptions.setRdFlag(AddressResolverConfig.getBooleanProperty(configSource, true, "addressResolver." + tag + ".rdFlag", "addressResolver.rdFlag"));
        addressResolverOptions.setSearchDomains(AddressResolverConfig.getStringListProperty(configSource, AddressResolverOptions.DEFAULT_SEACH_DOMAINS, "addressResolver." + tag + ".searchDomains", "addressResolver.searchDomains"));
        addressResolverOptions.setNdots(AddressResolverConfig.getPositiveIntProperty(configSource, AddressResolverOptions.DEFAULT_NDOTS, "addressResolver." + tag + ".ndots", "addressResolver.ndots"));
        addressResolverOptions.setRotateServers(AddressResolverConfig.getBooleanProperty(configSource, AddressResolverOptions.DEFAULT_ROTATE_SERVERS, "addressResolver." + tag + ".rotateServers", "addressResolver.rotateServers"));
        return addressResolverOptions;
    }

    private static List<String> getStringListProperty(Configuration configSource, List<String> defaultValue, String ... keys) {
        if ((configSource = AddressResolverConfig.guardConfigSource(configSource)) == null) {
            return defaultValue;
        }
        for (String key : keys) {
            String[] vals = configSource.getStringArray(key);
            if (vals == null || vals.length <= 0) continue;
            return Arrays.asList(vals);
        }
        return defaultValue;
    }

    private static int getPositiveIntProperty(Configuration configSource, int defaultValue, String ... keys) {
        if ((configSource = AddressResolverConfig.guardConfigSource(configSource)) == null) {
            return defaultValue;
        }
        for (String key : keys) {
            Integer val = configSource.getInteger(key, null);
            if (val != null && val <= 0) {
                LOGGER.warn("Address resover key:{}'s value:{} is not positive, please check!", (Object)key, (Object)val);
                continue;
            }
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Configuration configSource, boolean defaultValue, String ... keys) {
        if ((configSource = AddressResolverConfig.guardConfigSource(configSource)) == null) {
            return defaultValue;
        }
        for (String key : keys) {
            Boolean val = configSource.getBoolean(key, null);
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    private static Configuration guardConfigSource(Configuration configSource) {
        if (configSource == null && DynamicPropertyFactory.getBackingConfigurationSource() != null) {
            configSource = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();
        }
        return configSource;
    }
}

