/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.HttpServerChannelInitializer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class HttpServerImpl
implements HttpServer,
Closeable,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> log.trace((Object)"Connection failure", (Throwable)t);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final String DISABLE_H2C_PROP_NAME = "vertx.disableH2c";
    static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    final HttpServerOptions options;
    final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final ContextInternal creatingContext;
    private final boolean disableH2c = Boolean.getBoolean("vertx.disableH2c");
    final Map<Channel, ConnectionBase> connectionMap = new ConcurrentHashMap<Channel, ConnectionBase>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<HttpHandlers> httpHandlerMgr = new HandlerManager(this.availableWorkers);
    private final HttpStreamHandler<ServerWebSocket> wsStream = new HttpStreamHandler();
    private final HttpStreamHandler<HttpServerRequest> requestStream = new HttpStreamHandler();
    private Handler<HttpConnection> connectionHandler;
    private ChannelGroup serverChannelGroup;
    private volatile boolean listening;
    private io.netty.util.concurrent.Future<Channel> bindFuture;
    private ServerID id;
    private HttpServerImpl actualServer;
    private volatile int actualPort;
    private ContextInternal listenContext;
    HttpServerMetrics metrics;
    private Handler<Throwable> exceptionHandler;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        this.options = new HttpServerOptions(options);
        this.vertx = vertx;
        this.creatingContext = vertx.getContext();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public ReadStream<HttpServerRequest> requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> handler) {
        this.websocketStream().handler(handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ReadStream<ServerWebSocket> websocketStream() {
        return this.wsStream;
    }

    @Override
    public HttpServer listen() {
        return this.listen(this.options.getPort(), this.options.getHost(), null);
    }

    @Override
    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public HttpServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public HttpServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    @Override
    public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(SocketAddress.inetSocketAddress(port, host), listenHandler);
    }

    private ChannelHandler childHandler(SocketAddress address, String serverOrigin) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        this.metrics = vertxMetrics != null ? vertxMetrics.createHttpServerMetrics(this.options, address) : null;
        return new HttpServerChannelInitializer(this.vertx, this.sslHelper, this.options, serverOrigin, this.metrics, this.disableH2c, this.httpHandlerMgr::chooseHandler, eventLoop -> {
            HandlerHolder<HttpHandlers> holder = this.httpHandlerMgr.chooseHandler((EventLoop)eventLoop);
            if (holder != null && ((HttpHandlers)holder.handler).exceptionHandler != null) {
                return new HandlerHolder<Handler<Throwable>>(holder.context, ((HttpHandlers)holder.handler).exceptionHandler);
            }
            return null;
        }){

            @Override
            protected void initChannel(Channel ch) {
                if (!HttpServerImpl.this.requestStream.accept() || !HttpServerImpl.this.wsStream.accept()) {
                    ch.close();
                } else {
                    super.initChannel(ch);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        Map<ServerID, HttpServerImpl> sharedHttpServers;
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Already listening");
        }
        this.listenContext = this.vertx.getOrCreateContext();
        this.listening = true;
        String host = address.host() != null ? address.host() : "localhost";
        int port = address.port();
        List<HttpVersion> applicationProtocols = this.options.getAlpnVersions();
        if (this.listenContext.isWorkerContext()) {
            applicationProtocols = applicationProtocols.stream().filter(v -> v != HttpVersion.HTTP_2).collect(Collectors.toList());
        }
        this.sslHelper.setApplicationProtocols(applicationProtocols);
        Map<ServerID, HttpServerImpl> map = sharedHttpServers = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            HttpServerImpl shared = sharedHttpServers.get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), (EventLoopGroup)this.availableWorkers);
                this.applyConnectionOptions(address.path() != null, bootstrap);
                this.sslHelper.validate(this.vertx);
                String serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port;
                bootstrap.childHandler(this.childHandler(address, serverOrigin));
                this.addHandlers(this, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, address, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (!res.isSuccess()) {
                            Map map = sharedHttpServers;
                            synchronized (map) {
                                sharedHttpServers.remove(this.id);
                            }
                        } else {
                            Channel serverChannel = (Channel)res.getNow();
                            this.actualPort = serverChannel.localAddress() instanceof InetSocketAddress ? ((InetSocketAddress)serverChannel.localAddress()).getPort() : address.port();
                            this.serverChannelGroup.add((Object)serverChannel);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return this;
                }
                sharedHttpServers.put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort;
                this.addHandlers(this.actualServer, this.listenContext);
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createHttpServerMetrics(this.options, address) : null;
            }
            this.actualServer.bindFuture.addListener(future -> {
                if (listenHandler != null) {
                    Future<HttpServerImpl> res;
                    if (future.isSuccess()) {
                        res = Future.succeededFuture(this);
                    } else {
                        res = Future.failedFuture(future.cause());
                        this.listening = false;
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(res));
                } else if (!future.isSuccess()) {
                    this.listening = false;
                    if (this.metrics != null) {
                        this.metrics.close();
                        this.metrics = null;
                    }
                    log.error(future.cause());
                }
            });
        }
        return this;
    }

    public void closeAll(Handler<AsyncResult<Void>> handler) {
        List<HttpHandlers> list = this.httpHandlerMgr.handlers();
        List<Future> futures = list.stream().map(handlers -> Future.future(handlers.server::close)).collect(Collectors.toList());
        CompositeFuture fut = CompositeFuture.all(futures);
        fut.setHandler(ar -> handler.handle(ar.mapEmpty()));
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            Handler<AsyncResult<Void>> next = done;
            done = event -> {
                if (event.succeeded()) {
                    if (wsEndHandler != null) {
                        wsEndHandler.handle((Void)event.result());
                    }
                    if (requestEndHandler != null) {
                        requestEndHandler.handle((Void)event.result());
                    }
                }
                if (next != null) {
                    next.handle((AsyncResult<Void>)event);
                }
            };
        }
        ContextInternal context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            this.executeCloseDone(context, done, null);
            return;
        }
        this.listening = false;
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.httpHandlerMgr.removeHandler(new HttpHandlers(this, this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), this.listenContext);
                if (this.actualServer.httpHandlerMgr.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            } else {
                this.executeCloseDone(context, done, null);
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    public synchronized boolean isClosed() {
        return !this.listening;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    public SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    private void addHandlers(HttpServerImpl server, ContextInternal context) {
        server.httpHandlerMgr.addHandler(new HttpHandlers(this, this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), context);
    }

    private void actualClose(ContextInternal closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        ContextInternal currCon = this.vertx.getContext();
        for (ConnectionBase conn : this.connectionMap.values()) {
            conn.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        if (this.metrics != null) {
            this.metrics.close();
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(cgf -> this.executeCloseDone(closeContext, done, (Exception)fut.cause()));
    }

    @Override
    public int actualPort() {
        return this.actualPort;
    }

    private void executeCloseDone(ContextInternal closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e != null ? Future.failedFuture(e) : Future.succeededFuture();
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    class HttpStreamHandler<C extends ReadStream<Buffer>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private long demand = Long.MAX_VALUE;
        private Handler<Void> endHandler;

        HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accept() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                boolean accept;
                boolean bl = accept = this.demand > 0L;
                if (accept && this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                return accept;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.listening) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = 0L;
                return this;
            }
        }

        @Override
        public ReadStream fetch(long amount) {
            if (amount > 0L) {
                this.demand += amount;
                if (this.demand < 0L) {
                    this.demand = Long.MAX_VALUE;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = Long.MAX_VALUE;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public ReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

