/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import org.jruby.MetaClass;
import org.jruby.PrependedModule;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.NullMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.CodegenUtils;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected RubyModule definedClass;
    private byte visibility;
    protected long serialNumber;
    protected byte flags;
    protected final String name;
    protected Object handle;
    private static final int BUILTIN_FLAG = 1;
    private static final int NOTIMPL_FLAG = 2;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, String name2) {
        assert (implementationClass != null);
        if (name2 == null) {
            name2 = "null";
        }
        this.name = name2;
        this.init(implementationClass, visibility);
    }

    protected DynamicMethod(String name2) {
        this.visibility = (byte)Visibility.PUBLIC.ordinal();
        if (name2 == null) {
            name2 = "null";
        }
        this.name = name2;
    }

    protected void init(RubyModule implementationClass, Visibility visibility) {
        this.visibility = (byte)visibility.ordinal();
        this.implementationClass = implementationClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implementationClass);
        this.serialNumber = implementationClass.getRuntime().getNextDynamicMethodSerial();
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isBuiltin() {
        return (this.flags & 1) == 1;
    }

    public void setIsBuiltin(boolean isBuiltin) {
        this.flags = isBuiltin ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self2, clazz, name2, args2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
        return this.call(context, self2, klazz, name2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
        return this.call(context, self2, klazz, name2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0) {
        return this.call(context, self2, klazz, name2, arg0, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, self2, klazz, name2, arg0, arg1, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0, arg1}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self2, klazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller2, CallType callType) {
        switch (Visibility.getValues()[this.visibility]) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(caller2);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject caller2) {
        return this.getProtectedClass().isInstance(caller2);
    }

    protected static RubyModule calculateProtectedClass(RubyModule cls) {
        if (cls.isSingleton()) {
            cls = cls.getSuperClass();
        }
        while (cls.isIncluded()) {
            cls = cls.getMetaClass();
        }
        if (cls instanceof MetaClass) {
            cls = ((MetaClass)cls).getRealClass();
        }
        if (cls instanceof PrependedModule) {
            cls = ((PrependedModule)cls).getNonIncludedClass();
        }
        return cls;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public boolean isImplementedBy(RubyModule other) {
        return this.implementationClass == other;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implClass);
    }

    public RubyModule getDefinedClass() {
        RubyModule definedClass = this.definedClass;
        if (definedClass != null) {
            return definedClass;
        }
        return this.implementationClass;
    }

    public void setDefinedClass(RubyModule definedClass) {
        this.definedClass = definedClass;
    }

    public Visibility getVisibility() {
        return Visibility.getValues()[this.visibility];
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = (byte)visibility.ordinal();
    }

    public final boolean isUndefined() {
        return this == UndefinedMethod.INSTANCE;
    }

    public final boolean isNull() {
        return this == NullMethod.INSTANCE;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public boolean isNative() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Object getHandle() {
        return this.handle;
    }

    public void setHandle(Object handle) {
        this.handle = handle;
    }

    public boolean isNotImplemented() {
        return (this.flags & 2) == 2;
    }

    public MethodData getMethodData() {
        return MethodData.NULL;
    }

    public void setNotImplemented(boolean setNotImplemented) {
        this.flags = setNotImplemented ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    @Deprecated
    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this(implementationClass, visibility);
    }

    @Deprecated
    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, String name2) {
        this(implementationClass, visibility, name2);
    }

    @Deprecated
    protected void init(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this.init(implementationClass, visibility);
    }

    @Deprecated
    public CallConfiguration getCallConfig() {
        return CallConfiguration.FrameNoneScopeNone;
    }

    @Deprecated
    public void setCallConfig(CallConfiguration callConfig) {
    }

    @Deprecated
    protected DynamicMethod(RubyModule implementationClass, Visibility visibility) {
        this(implementationClass, visibility, "(anonymous)");
    }

    public static class NativeCall {
        private final Class nativeTarget;
        private final String nativeName;
        private final Class nativeReturn;
        private final Class[] nativeSignature;
        private final boolean statik;
        private final boolean java;
        private Method reflected;

        public NativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik) {
            this(nativeTarget, nativeName, nativeReturn, nativeSignature, statik, false);
        }

        public NativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik, boolean java2) {
            this.nativeTarget = nativeTarget;
            this.nativeName = nativeName;
            this.nativeReturn = nativeReturn;
            this.nativeSignature = nativeSignature;
            this.statik = statik;
            this.java = java2;
        }

        public Class getNativeTarget() {
            return this.nativeTarget;
        }

        public String getNativeName() {
            return this.nativeName;
        }

        public Class getNativeReturn() {
            return this.nativeReturn;
        }

        public Class[] getNativeSignature() {
            return this.nativeSignature;
        }

        public boolean isStatic() {
            return this.statik;
        }

        public boolean isJava() {
            return this.java;
        }

        public boolean hasContext() {
            return this.nativeSignature.length > 0 && this.nativeSignature[0] == ThreadContext.class;
        }

        public boolean hasBlock() {
            return this.nativeSignature.length > 0 && this.nativeSignature[this.nativeSignature.length - 1] == Block.class;
        }

        public Method getMethod() {
            Method reflected = this.reflected;
            if (reflected != null) {
                return reflected;
            }
            try {
                this.reflected = this.nativeTarget.getDeclaredMethod(this.nativeName, this.nativeSignature);
                return this.reflected;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return (this.statik ? "static " : "") + this.nativeReturn.getSimpleName() + ' ' + this.nativeTarget.getSimpleName() + '.' + this.nativeName + CodegenUtils.prettyShortParams(this.nativeSignature);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Version {
        public int version() default 0;
    }
}

