/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.event;

import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.filter.IsolationDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;

public class IsolationServerEvent
extends AlarmEvent {
    private String microserviceName;
    private Endpoint endpoint;
    private MicroserviceInstance instance;
    private long currentTotalRequest;
    private long currentCountinuousFailureCount;
    private double currentErrorPercentage;
    private int minIsolationTime;
    private long enableRequestThreshold;
    private int continuousFailureThreshold;
    private int errorThresholdPercentage;
    private long singleTestTime;

    public IsolationServerEvent(Invocation invocation, MicroserviceInstance instance, ServiceCombServerStats serverStats, IsolationDiscoveryFilter.Settings settings, AlarmEvent.Type type, Endpoint endpoint) {
        super(type);
        this.microserviceName = invocation.getMicroserviceName();
        this.endpoint = endpoint;
        this.currentTotalRequest = serverStats.getTotalRequests();
        this.currentCountinuousFailureCount = serverStats.getCountinuousFailureCount();
        this.currentErrorPercentage = serverStats.getFailedRate();
        this.minIsolationTime = settings.minIsolationTime;
        this.enableRequestThreshold = settings.enableRequestThreshold;
        this.continuousFailureThreshold = settings.continuousFailureThreshold;
        this.errorThresholdPercentage = settings.errorThresholdPercentage;
        this.singleTestTime = settings.singleTestTime;
        this.instance = instance;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public long getCurrentTotalRequest() {
        return this.currentTotalRequest;
    }

    public long getCurrentCountinuousFailureCount() {
        return this.currentCountinuousFailureCount;
    }

    public double getCurrentErrorPercentage() {
        return this.currentErrorPercentage;
    }

    public long getEnableRequestThreshold() {
        return this.enableRequestThreshold;
    }

    public int getContinuousFailureThreshold() {
        return this.continuousFailureThreshold;
    }

    public int getErrorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }

    public long getSingleTestTime() {
        return this.singleTestTime;
    }

    public MicroserviceInstance getInstance() {
        return this.instance;
    }

    public int getMinIsolationTime() {
        return this.minIsolationTime;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

