/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.TimeUtils;
import org.apache.servicecomb.loadbalance.TryingIsolatedServerMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombServerStats {
    private static final long TIME_WINDOW_IN_MILLISECONDS = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServerStats.class);
    private final Object lock = new Object();
    static AtomicReference<TryingIsolatedServerMarker> globalAllowIsolatedServerTryingFlag = new AtomicReference();
    private long lastWindow = System.currentTimeMillis();
    Clock clock;
    private AtomicLong continuousFailureCount = new AtomicLong(0L);
    private long lastVisitTime = System.currentTimeMillis();
    private long lastActiveTime = System.currentTimeMillis();
    private AtomicLong totalRequests = new AtomicLong(0L);
    private AtomicLong successRequests = new AtomicLong(0L);
    private AtomicLong failedRequests = new AtomicLong(0L);
    private boolean isolated = false;

    public ServiceCombServerStats() {
        this.clock = TimeUtils.getSystemDefaultZoneClock();
        this.init();
    }

    public ServiceCombServerStats(Clock clock) {
        this.clock = clock;
        this.init();
    }

    private void init() {
        this.lastWindow = this.clock.millis();
        this.continuousFailureCount = new AtomicLong(0L);
        this.lastVisitTime = this.clock.millis();
        this.lastActiveTime = this.clock.millis();
        this.totalRequests = new AtomicLong(0L);
        this.successRequests = new AtomicLong(0L);
        this.failedRequests = new AtomicLong(0L);
    }

    public static boolean isolatedServerCanTry() {
        TryingIsolatedServerMarker marker = globalAllowIsolatedServerTryingFlag.get();
        if (marker == null) {
            return true;
        }
        return marker.isOutdated();
    }

    public static boolean applyForTryingChance(Invocation invocation) {
        TryingIsolatedServerMarker marker = globalAllowIsolatedServerTryingFlag.get();
        if (marker == null) {
            return globalAllowIsolatedServerTryingFlag.compareAndSet(null, new TryingIsolatedServerMarker(invocation));
        }
        if (marker.isOutdated()) {
            return globalAllowIsolatedServerTryingFlag.compareAndSet(marker, new TryingIsolatedServerMarker(invocation));
        }
        return false;
    }

    public static void checkAndReleaseTryingChance(Invocation invocation) {
        TryingIsolatedServerMarker marker = globalAllowIsolatedServerTryingFlag.get();
        if (marker == null || marker.getInvocation() != invocation) {
            return;
        }
        globalAllowIsolatedServerTryingFlag.compareAndSet(marker, null);
    }

    public void markIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void markSuccess() {
        long time = System.currentTimeMillis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        this.lastActiveTime = time;
        this.totalRequests.incrementAndGet();
        this.successRequests.incrementAndGet();
        this.continuousFailureCount.set(0L);
        if (this.isolated) {
            LOGGER.info("trying server invocation success!");
        }
    }

    public void markFailure() {
        long time = System.currentTimeMillis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        if (!this.isolated) {
            this.totalRequests.incrementAndGet();
            this.failedRequests.incrementAndGet();
            this.continuousFailureCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWindow(long time) {
        if (time - this.lastWindow > 60000L) {
            Object object = this.lock;
            synchronized (object) {
                if (time - this.lastWindow > 60000L) {
                    if (!this.isolated) {
                        this.continuousFailureCount.set(0L);
                        this.totalRequests.set(0L);
                        this.successRequests.set(0L);
                        this.failedRequests.set(0L);
                    }
                    this.lastWindow = time;
                }
            }
        }
    }

    public long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public long getCountinuousFailureCount() {
        return this.continuousFailureCount.get();
    }

    public long getTotalRequests() {
        return this.totalRequests.get();
    }

    public long getSuccessRequests() {
        return this.successRequests.get();
    }

    public long getFailedRequests() {
        return this.failedRequests.get();
    }

    public int getSuccessRate() {
        return this.calcRequestRate(this.successRequests);
    }

    public int getFailedRate() {
        return this.calcRequestRate(this.failedRequests);
    }

    private int calcRequestRate(AtomicLong requestCnt) {
        long totalReqs = this.totalRequests.get();
        if (totalReqs == 0L) {
            return 0;
        }
        return (int)(requestCnt.get() * 100L / totalReqs);
    }

    public boolean isIsolated() {
        return this.isolated;
    }
}

