/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceInstancePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombLoadBalancerStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombLoadBalancerStats.class);
    private final Map<ServiceCombServer, ServiceCombServerStats> pingView = new ConcurrentHashMap<ServiceCombServer, ServiceCombServerStats>();
    private int serverExpireInSeconds = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.loadbalance.stats.serverExpiredInSeconds", 300).get();
    private long timerIntervalInMillis = DynamicPropertyFactory.getInstance().getLongProperty("servicecomb.loadbalance.stats.timerIntervalInMilis", 10000L).get();
    private LoadingCache<ServiceCombServer, ServiceCombServerStats> serverStatsCache;
    private Map<String, ServiceCombServer> serviceCombServers = new ConcurrentHashMap<String, ServiceCombServer>();
    public static final ServiceCombLoadBalancerStats INSTANCE = new ServiceCombLoadBalancerStats();
    private Timer timer;

    ServiceCombLoadBalancerStats() {
    }

    public void markIsolated(ServiceCombServer server, boolean isolated) {
        try {
            ((ServiceCombServerStats)this.serverStatsCache.get((Object)server)).markIsolated(isolated);
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public void markSuccess(ServiceCombServer server) {
        try {
            ((ServiceCombServerStats)this.serverStatsCache.get((Object)server)).markSuccess();
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public void markFailure(ServiceCombServer server) {
        try {
            ((ServiceCombServerStats)this.serverStatsCache.get((Object)server)).markFailure();
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public ServiceCombServerStats getServiceCombServerStats(ServiceCombServer server) {
        try {
            return (ServiceCombServerStats)this.serverStatsCache.get((Object)server);
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
            return null;
        }
    }

    public ServiceCombServer getServiceCombServer(MicroserviceInstance instance) {
        return this.serviceCombServers.get(instance.getInstanceId());
    }

    public ServiceCombServer getServiceCombServerOld(MicroserviceInstance instance) {
        for (ServiceCombServer server : this.serverStatsCache.asMap().keySet()) {
            if (!server.getInstance().equals((Object)instance)) continue;
            return server;
        }
        return null;
    }

    @VisibleForTesting
    void setServerExpireInSeconds(int sec) {
        this.serverExpireInSeconds = sec;
    }

    @VisibleForTesting
    void setTimerIntervalInMillis(int milis) {
        this.timerIntervalInMillis = milis;
    }

    @VisibleForTesting
    Map<ServiceCombServer, ServiceCombServerStats> getPingView() {
        return this.pingView;
    }

    void init() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.serverStatsCache != null) {
            this.serverStatsCache.cleanUp();
        }
        this.serverStatsCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.serverExpireInSeconds, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<ServiceCombServer, ServiceCombServerStats>(){

            public void onRemoval(RemovalNotification<ServiceCombServer, ServiceCombServerStats> notification) {
                ServiceCombServer server = (ServiceCombServer)((Object)notification.getKey());
                LOGGER.info("stats of instance {} removed. host is {}", (Object)server.getInstance().getInstanceId(), (Object)server.getHost());
                ServiceCombLoadBalancerStats.this.pingView.remove(notification.getKey());
                ServiceCombLoadBalancerStats.this.serviceCombServers.remove(notification.getKey());
            }
        }).build((CacheLoader)new CacheLoader<ServiceCombServer, ServiceCombServerStats>(){

            public ServiceCombServerStats load(ServiceCombServer server) {
                ServiceCombServerStats stats = new ServiceCombServerStats();
                ServiceCombLoadBalancerStats.this.pingView.put(server, stats);
                ServiceCombLoadBalancerStats.this.serviceCombServers.put(server.getInstance().getInstanceId(), server);
                return stats;
            }
        });
        this.timer = new Timer("LoadBalancerStatsTimer", true);
        this.timer.schedule(new TimerTask(){
            private MicroserviceInstancePing ping = (MicroserviceInstancePing)SPIServiceUtils.getPriorityHighestService(MicroserviceInstancePing.class);

            @Override
            public void run() {
                try {
                    Map allServers = ServiceCombLoadBalancerStats.this.pingView;
                    allServers.entrySet().forEach(serviceCombServerServiceCombServerStatsEntry -> {
                        ServiceCombServer server = (ServiceCombServer)((Object)((Object)serviceCombServerServiceCombServerStatsEntry.getKey()));
                        ServiceCombServerStats stats = (ServiceCombServerStats)serviceCombServerServiceCombServerStatsEntry.getValue();
                        if (System.currentTimeMillis() - stats.getLastVisitTime() > ServiceCombLoadBalancerStats.this.timerIntervalInMillis && !this.ping.ping(server.getInstance())) {
                            LOGGER.info("ping mark server {} failure.", (Object)server.getInstance().getInstanceId());
                            stats.markFailure();
                        }
                    });
                    ServiceCombLoadBalancerStats.this.serverStatsCache.cleanUp();
                }
                catch (Throwable e) {
                    LOGGER.warn("LoadBalancerStatsTimer error.", e);
                }
            }
        }, this.timerIntervalInMillis, this.timerIntervalInMillis);
    }

    static {
        INSTANCE.init();
    }
}

