/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public final class YAMLUtil {
    private YAMLUtil() {
    }

    public static Map<String, Object> yaml2Properties(InputStream input) {
        LinkedHashMap<String, Object> configurations = new LinkedHashMap<String, Object>();
        Yaml yaml = new Yaml();
        yaml.loadAll(input).forEach(data -> configurations.putAll(YAMLUtil.retrieveItems("", (Map)data)));
        return configurations;
    }

    public static Map<String, Object> retrieveItems(String prefix, Map<String, Object> propertieMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        for (Map.Entry<String, Object> entry : propertieMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                result.putAll(YAMLUtil.retrieveItems(prefix + entry.getKey(), (Map)entry.getValue()));
                continue;
            }
            String key = prefix + entry.getKey();
            if (key.startsWith("cse.")) {
                String servicecombKey = "servicecomb." + key.substring(key.indexOf(".") + 1);
                result.put(servicecombKey, entry.getValue());
            }
            result.put(key, entry.getValue());
        }
        return result;
    }
}

