/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileResolver;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.MultiThreadedWorkerContext;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.WorkerExecutorImpl;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.resolver.DnsResolverProvider;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class VertxImpl
implements VertxInternal,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(VertxImpl.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final String NETTY_IO_RATIO_PROPERTY_NAME = "vertx.nettyIORatio";
    private static final int NETTY_IO_RATIO = Integer.getInteger("vertx.nettyIORatio", 50);
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final DeploymentManager deploymentManager;
    private final FileResolver fileResolver;
    private final Map<ServerID, HttpServerImpl> sharedHttpServers = new HashMap<ServerID, HttpServerImpl>();
    private final Map<ServerID, NetServerImpl> sharedNetServers = new HashMap<ServerID, NetServerImpl>();
    final WorkerPool workerPool;
    final WorkerPool internalBlockingPool;
    private final ThreadFactory eventLoopThreadFactory;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup acceptorEventLoopGroup;
    private final BlockedThreadChecker checker;
    private final AddressResolver addressResolver;
    private final AddressResolverOptions addressResolverOptions;
    private final EventBus eventBus;
    private volatile HAManager haManager;
    private boolean closed;
    private volatile Handler<Throwable> exceptionHandler;
    private final Map<String, SharedWorkerPool> namedWorkerPools;
    private final int defaultWorkerPoolSize;
    private final long defaultWorkerMaxExecTime;
    private final CloseHooks closeHooks;
    private final Transport transport;

    static VertxImpl vertx(VertxOptions options) {
        VertxImpl vertx = new VertxImpl(options, Transport.transport((boolean)options.getPreferNativeTransport()));
        vertx.init();
        return vertx;
    }

    static VertxImpl vertx(VertxOptions options, Transport transport) {
        VertxImpl vertx = new VertxImpl(options, transport);
        vertx.init();
        return vertx;
    }

    static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        VertxImpl vertx = new VertxImpl(options, Transport.transport((boolean)options.getPreferNativeTransport()));
        vertx.joinCluster(options, resultHandler);
    }

    public VertxImpl(VertxOptions options, Transport transport) {
        if (Vertx.currentContext() != null) {
            log.warn((Object)"You're already on a Vert.x context, are you sure you want to create a new Vertx instance?");
        }
        this.closeHooks = new CloseHooks(log);
        this.checker = new BlockedThreadChecker(options.getBlockedThreadCheckInterval(), options.getBlockedThreadCheckIntervalUnit(), options.getWarningExceptionTime(), options.getWarningExceptionTimeUnit());
        this.eventLoopThreadFactory = new VertxThreadFactory("vert.x-eventloop-thread-", this.checker, false, options.getMaxEventLoopExecuteTime(), options.getMaxEventLoopExecuteTimeUnit());
        this.eventLoopGroup = transport.eventLoopGroup(options.getEventLoopPoolSize(), this.eventLoopThreadFactory, NETTY_IO_RATIO);
        VertxThreadFactory acceptorEventLoopThreadFactory = new VertxThreadFactory("vert.x-acceptor-thread-", this.checker, false, options.getMaxEventLoopExecuteTime(), options.getMaxEventLoopExecuteTimeUnit());
        this.acceptorEventLoopGroup = transport.eventLoopGroup(1, (ThreadFactory)acceptorEventLoopThreadFactory, 100);
        this.metrics = this.initialiseMetrics(options);
        ExecutorService workerExec = Executors.newFixedThreadPool(options.getWorkerPoolSize(), (ThreadFactory)new VertxThreadFactory("vert.x-worker-thread-", this.checker, true, options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit()));
        PoolMetrics workerPoolMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", "vert.x-worker-thread", options.getWorkerPoolSize()) : null;
        ExecutorService internalBlockingExec = Executors.newFixedThreadPool(options.getInternalBlockingPoolSize(), (ThreadFactory)new VertxThreadFactory("vert.x-internal-blocking-", this.checker, true, options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit()));
        PoolMetrics internalBlockingPoolMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", "vert.x-internal-blocking", options.getInternalBlockingPoolSize()) : null;
        this.internalBlockingPool = new WorkerPool(internalBlockingExec, internalBlockingPoolMetrics);
        this.namedWorkerPools = new HashMap<String, SharedWorkerPool>();
        this.workerPool = new WorkerPool(workerExec, workerPoolMetrics);
        this.defaultWorkerPoolSize = options.getWorkerPoolSize();
        this.defaultWorkerMaxExecTime = options.getMaxWorkerExecuteTime();
        this.transport = transport;
        this.fileResolver = new FileResolver(options.getFileSystemOptions());
        this.addressResolverOptions = options.getAddressResolverOptions();
        this.addressResolver = new AddressResolver((Vertx)this, options.getAddressResolverOptions());
        this.deploymentManager = new DeploymentManager((VertxInternal)this);
        if (options.isClustered()) {
            this.clusterManager = this.getClusterManager(options);
            this.eventBus = new ClusteredEventBus((VertxInternal)this, options, this.clusterManager);
        } else {
            this.clusterManager = null;
            this.eventBus = new EventBusImpl((VertxInternal)this);
        }
        this.sharedData = new SharedDataImpl((VertxInternal)this, this.clusterManager);
    }

    public void init() {
        this.eventBus.start(ar -> {});
        if (this.metrics != null) {
            this.metrics.vertxCreated((Vertx)this);
        }
    }

    private void joinCluster(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.clusterManager.setVertx((Vertx)this);
        this.clusterManager.join(ar -> {
            if (ar.succeeded()) {
                this.createHaManager(options, resultHandler);
            } else {
                log.error((Object)"Failed to join cluster", ar.cause());
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void createHaManager(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.executeBlocking(fut -> fut.complete((Object)this.clusterManager.getSyncMap(CLUSTER_MAP_NAME)), false, ar -> {
            if (ar.succeeded()) {
                Map clusterMap = (Map)ar.result();
                this.haManager = new HAManager((VertxInternal)this, this.deploymentManager, this.clusterManager, clusterMap, options.getQuorumSize(), options.getHAGroup(), options.isHAEnabled());
                this.startEventBus(resultHandler);
            } else {
                log.error((Object)"Failed to start HAManager", ar.cause());
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void startEventBus(Handler<AsyncResult<Vertx>> resultHandler) {
        this.eventBus.start(ar -> {
            if (ar.succeeded()) {
                this.initializeHaManager(resultHandler);
            } else {
                log.error((Object)"Failed to start event bus", ar.cause());
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void initializeHaManager(Handler<AsyncResult<Vertx>> resultHandler) {
        this.executeBlocking(fut -> {
            this.haManager.init();
            fut.complete();
        }, false, ar -> {
            if (ar.succeeded()) {
                if (this.metrics != null) {
                    this.metrics.vertxCreated((Vertx)this);
                }
                resultHandler.handle((Object)Future.succeededFuture((Object)this));
            } else {
                log.error((Object)"Failed to initialize HAManager", ar.cause());
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    protected FileSystem getFileSystem() {
        return Utils.isWindows() ? new WindowsFileSystem((VertxInternal)this) : new FileSystemImpl((VertxInternal)this);
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        return DatagramSocketImpl.create((VertxInternal)this, (DatagramSocketOptions)options);
    }

    public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    public NetServer createNetServer(NetServerOptions options) {
        return new NetServerImpl((VertxInternal)this, options);
    }

    public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    public NetClient createNetClient(NetClientOptions options) {
        return new NetClientImpl((VertxInternal)this, options);
    }

    public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    public Transport transport() {
        return this.transport;
    }

    public boolean isNativeTransportEnabled() {
        return this.transport != Transport.JDK;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public SharedData sharedData() {
        return this.sharedData;
    }

    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl((VertxInternal)this, serverOptions);
    }

    public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    public HttpClient createHttpClient(HttpClientOptions options) {
        return new HttpClientImpl((VertxInternal)this, options);
    }

    public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions());
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, true);
    }

    public TimeoutStream periodicStream(long delay) {
        return new TimeoutStreamImpl(delay, true);
    }

    public long setTimer(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, false);
    }

    public TimeoutStream timerStream(long delay) {
        return new TimeoutStreamImpl(delay, false);
    }

    public void runOnContext(Handler<Void> task) {
        ContextImpl context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool.executor();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public EventLoopGroup getAcceptorEventLoopGroup() {
        return this.acceptorEventLoopGroup;
    }

    public ContextImpl getOrCreateContext() {
        ContextImpl ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext(null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
        }
        return ctx;
    }

    public Map<ServerID, HttpServerImpl> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    public Map<ServerID, NetServerImpl> sharedNetServers() {
        return this.sharedNetServers;
    }

    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.remove(id);
        if (handler != null) {
            handler.context.removeCloseHook((Closeable)handler);
            return handler.cancel();
        }
        return false;
    }

    public EventLoopContext createEventLoopContext(String deploymentID, WorkerPool workerPool, JsonObject config, ClassLoader tccl) {
        return new EventLoopContext((VertxInternal)this, this.internalBlockingPool, workerPool != null ? workerPool : this.workerPool, deploymentID, config, tccl);
    }

    public ContextImpl createWorkerContext(boolean multiThreaded, String deploymentID, WorkerPool workerPool, JsonObject config, ClassLoader tccl) {
        if (workerPool == null) {
            workerPool = this.workerPool;
        }
        if (multiThreaded) {
            return new MultiThreadedWorkerContext((VertxInternal)this, this.internalBlockingPool, workerPool, deploymentID, config, tccl);
        }
        return new WorkerContext((VertxInternal)this, this.internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    public DnsClient createDnsClient(int port, String host) {
        return this.createDnsClient(new DnsClientOptions().setHost(host).setPort(port));
    }

    public DnsClient createDnsClient() {
        return this.createDnsClient(new DnsClientOptions());
    }

    public DnsClient createDnsClient(DnsClientOptions options) {
        String host = options.getHost();
        int port = options.getPort();
        if (host == null || port < 0) {
            DnsResolverProvider provider = new DnsResolverProvider(this, this.addressResolverOptions);
            InetSocketAddress address = (InetSocketAddress)provider.nameServerAddresses().get(0);
            options = new DnsClientOptions(options).setHost(address.getAddress().getHostAddress()).setPort(address.getPort());
        }
        return new DnsClientImpl((VertxInternal)this, options);
    }

    private VertxMetrics initialiseMetrics(VertxOptions options) {
        if (options.getMetricsOptions() != null && options.getMetricsOptions().isEnabled()) {
            VertxMetricsFactory factory = options.getMetricsOptions().getFactory();
            if (factory == null && (factory = (VertxMetricsFactory)ServiceHelper.loadFactoryOrNull(VertxMetricsFactory.class)) == null) {
                log.warn((Object)"Metrics has been set to enabled but no VertxMetricsFactory found on classpath");
            }
            if (factory != null) {
                VertxMetrics metrics = factory.metrics(options);
                Objects.requireNonNull(metrics, "The metric instance created from " + factory + " cannot be null");
                return metrics;
            }
        }
        return null;
    }

    private ClusterManager getClusterManager(VertxOptions options) {
        ClusterManager mgr = options.getClusterManager();
        if (mgr == null) {
            String clusterManagerClassName = System.getProperty("vertx.cluster.managerClass");
            if (clusterManagerClassName != null) {
                try {
                    Class<?> clazz = Class.forName(clusterManagerClassName);
                    mgr = (ClusterManager)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate " + clusterManagerClassName, e);
                }
            } else {
                mgr = (ClusterManager)ServiceHelper.loadFactoryOrNull(ClusterManager.class);
                if (mgr == null) {
                    throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
                }
            }
        }
        return mgr;
    }

    private long scheduleTimeout(ContextImpl context, Handler<Long> handler, long delay, boolean periodic) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, delay, context);
        this.timeouts.put(timerId, task);
        context.addCloseHook((Closeable)task);
        return timerId;
    }

    public static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)current).getContext();
        }
        return null;
    }

    public ContextImpl getContext() {
        ContextImpl context = (ContextImpl)VertxImpl.context();
        if (context != null && context.owner == this) {
            return context;
        }
        return null;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void close() {
        this.close(null);
    }

    private void closeClusterManager(Handler<AsyncResult<Void>> completionHandler) {
        if (this.clusterManager != null) {
            this.clusterManager.leave(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to leave cluster", ar.cause());
                }
                if (completionHandler != null) {
                    this.runOnContext((Handler<Void>)((Handler)v -> completionHandler.handle((Object)Future.succeededFuture())));
                }
            });
        } else if (completionHandler != null) {
            this.runOnContext((Handler<Void>)((Handler)v -> completionHandler.handle((Object)Future.succeededFuture())));
        }
    }

    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed || this.eventBus == null) {
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
            return;
        }
        this.closed = true;
        this.closeHooks.run(ar -> this.deploymentManager.undeployAll(ar1 -> {
            HAManager haManager = this.haManager();
            Future haFuture = Future.future();
            if (haManager != null) {
                this.executeBlocking((Handler)fut -> {
                    haManager.stop();
                    fut.complete();
                }, false, (Handler)haFuture);
            } else {
                haFuture.complete();
            }
            haFuture.setHandler(ar2 -> this.addressResolver.close(ar3 -> this.eventBus.close(ar4 -> this.closeClusterManager((Handler<AsyncResult<Void>>)((Handler)ar5 -> {
                HashSet<HttpServerImpl> httpServers = new HashSet<HttpServerImpl>(this.sharedHttpServers.values());
                HashSet<NetServerImpl> netServers = new HashSet<NetServerImpl>(this.sharedNetServers.values());
                this.sharedHttpServers.clear();
                this.sharedNetServers.clear();
                int serverCount = httpServers.size() + netServers.size();
                AtomicInteger serverCloseCount = new AtomicInteger();
                Handler serverCloseHandler = res -> {
                    if (res.failed()) {
                        log.error((Object)"Failure in shutting down server", res.cause());
                    }
                    if (serverCloseCount.incrementAndGet() == serverCount) {
                        this.deleteCacheDirAndShutdown(completionHandler);
                    }
                };
                for (HttpServerImpl httpServerImpl : httpServers) {
                    httpServerImpl.closeAll(serverCloseHandler);
                }
                for (NetServerImpl netServerImpl : netServers) {
                    netServerImpl.closeAll(serverCloseHandler);
                }
                if (serverCount == 0) {
                    this.deleteCacheDirAndShutdown(completionHandler);
                }
            })))));
        }));
    }

    public void deployVerticle(Verticle verticle) {
        this.deployVerticle(verticle, new DeploymentOptions(), null);
    }

    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(verticle, new DeploymentOptions(), completionHandler);
    }

    public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    public void deployVerticle(Verticle verticle, DeploymentOptions options) {
        this.deployVerticle(verticle, options, null);
    }

    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
        this.deployVerticle(() -> {
            try {
                return (Verticle)verticleClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, options);
    }

    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        this.deployVerticle(verticleSupplier, options, null);
    }

    public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.getInstances() != 1) {
            throw new IllegalArgumentException("Can't specify > 1 instances for already created verticle");
        }
        this.deployVerticle(() -> verticle, options, completionHandler);
    }

    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(() -> {
            try {
                return (Verticle)verticleClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, options, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        boolean closed;
        VertxImpl vertxImpl = this;
        synchronized (vertxImpl) {
            closed = this.closed;
        }
        if (closed) {
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.failedFuture((String)"Vert.x closed"));
            }
        } else {
            this.deploymentManager.deployVerticle(verticleSupplier, options, completionHandler);
        }
    }

    public void deployVerticle(String name) {
        this.deployVerticle(name, new DeploymentOptions(), null);
    }

    public void deployVerticle(String name, DeploymentOptions options) {
        this.deployVerticle(name, options, null);
    }

    public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.isHa() && this.haManager() != null && this.haManager().isEnabled()) {
            this.haManager().deployVerticle(name, options, completionHandler);
        } else {
            this.deploymentManager.deployVerticle(name, options, completionHandler);
        }
    }

    public String getNodeID() {
        return this.clusterManager.getNodeID();
    }

    public void undeploy(String deploymentID) {
        this.undeploy(deploymentID, (Handler<AsyncResult<Void>>)((Handler)res -> {}));
    }

    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        HAManager haManager = this.haManager();
        Future haFuture = Future.future();
        if (haManager != null && haManager.isEnabled()) {
            this.executeBlocking((Handler)fut -> {
                haManager.removeFromHA(deploymentID);
                fut.complete();
            }, false, (Handler)haFuture);
        } else {
            haFuture.complete();
        }
        haFuture.compose(v -> {
            Future deploymentFuture = Future.future();
            this.deploymentManager.undeployVerticle(deploymentID, (Handler)deploymentFuture);
            return deploymentFuture;
        }).setHandler(completionHandler);
    }

    public Set<String> deploymentIDs() {
        return this.deploymentManager.deployments();
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.registerVerticleFactory(factory);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.unregisterVerticleFactory(factory);
    }

    public Set<VerticleFactory> verticleFactories() {
        return this.deploymentManager.verticleFactories();
    }

    public <T> void executeBlockingInternal(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlockingInternal(blockingCodeHandler, resultHandler);
    }

    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, asyncResultHandler);
    }

    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        this.executeBlocking(blockingCodeHandler, true, asyncResultHandler);
    }

    public boolean isClustered() {
        return this.clusterManager != null;
    }

    public EventLoopGroup nettyEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    public Deployment getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    public synchronized void failoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().setFailoverCompleteHandler(failoverCompleteHandler);
        }
    }

    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    public void failDuringFailover(boolean fail) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail);
        }
    }

    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    public void resolveAddress(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        this.addressResolver.resolveHostname(hostname, resultHandler);
    }

    public AddressResolver addressResolver() {
        return this.addressResolver;
    }

    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.addressResolver.nettyAddressResolverGroup();
    }

    private void deleteCacheDirAndShutdown(final Handler<AsyncResult<Void>> completionHandler) {
        this.executeBlockingInternal(fut -> {
            try {
                this.fileResolver.close();
                fut.complete();
            }
            catch (IOException e) {
                fut.tryFail((Throwable)e);
            }
        }, ar -> {
            this.workerPool.close();
            this.internalBlockingPool.close();
            new ArrayList<SharedWorkerPool>(this.namedWorkerPools.values()).forEach(WorkerPool::close);
            this.acceptorEventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                    if (!future.isSuccess()) {
                        log.warn((Object)"Failure in shutting down acceptor event loop group", future.cause());
                    }
                    VertxImpl.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                            if (!future.isSuccess()) {
                                log.warn((Object)"Failure in shutting down event loop group", future.cause());
                            }
                            if (VertxImpl.this.metrics != null) {
                                VertxImpl.this.metrics.close();
                            }
                            VertxImpl.this.checker.close();
                            if (completionHandler != null) {
                                VertxImpl.this.eventLoopThreadFactory.newThread(() -> completionHandler.handle((Object)Future.succeededFuture())).start();
                            }
                        }
                    });
                }
            });
        });
    }

    public HAManager haManager() {
        return this.haManager;
    }

    public WorkerExecutorImpl createSharedWorkerExecutor(String name) {
        return this.createSharedWorkerExecutor(name, this.defaultWorkerPoolSize);
    }

    public WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize) {
        return this.createSharedWorkerExecutor(name, poolSize, this.defaultWorkerMaxExecTime);
    }

    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        return this.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, TimeUnit.NANOSECONDS);
    }

    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        if (maxExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        SharedWorkerPool sharedWorkerPool = this.namedWorkerPools.get(name);
        if (sharedWorkerPool == null) {
            ExecutorService workerExec = Executors.newFixedThreadPool(poolSize, (ThreadFactory)new VertxThreadFactory(name + "-", this.checker, true, maxExecuteTime, maxExecuteTimeUnit));
            PoolMetrics workerMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", name, poolSize) : null;
            sharedWorkerPool = new SharedWorkerPool(name, workerExec, workerMetrics);
            this.namedWorkerPools.put(name, sharedWorkerPool);
        } else {
            sharedWorkerPool.refCount++;
        }
        ContextImpl context = this.getOrCreateContext();
        WorkerExecutorImpl namedExec = new WorkerExecutorImpl((Context)context, sharedWorkerPool);
        context.addCloseHook((Closeable)namedExec);
        return namedExec;
    }

    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void addCloseHook(Closeable hook) {
        this.closeHooks.add(hook);
    }

    public void removeCloseHook(Closeable hook) {
        this.closeHooks.remove(hook);
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        System.setProperty("io.netty.noJdkZlibDecoder", "false");
    }

    class SharedWorkerPool
    extends WorkerPool {
        private final String name;
        private int refCount;

        SharedWorkerPool(String name, ExecutorService workerExec, PoolMetrics workerMetrics) {
            super(workerExec, workerMetrics);
            this.refCount = 1;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (this.refCount > 0) {
                    this.refCount = 0;
                    super.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (--this.refCount == 0) {
                    VertxImpl.this.namedWorkerPools.remove(this.name);
                    super.close();
                }
            }
        }
    }

    private class TimeoutStreamImpl
    implements TimeoutStream,
    Handler<Long> {
        private final long delay;
        private final boolean periodic;
        private Long id;
        private Handler<Long> handler;
        private Handler<Void> endHandler;
        private long demand;

        public TimeoutStreamImpl(long delay, boolean periodic) {
            this.delay = delay;
            this.periodic = periodic;
            this.demand = Long.MAX_VALUE;
        }

        public synchronized void handle(Long event) {
            try {
                if (this.demand > 0L) {
                    --this.demand;
                    this.handler.handle((Object)event);
                }
            }
            finally {
                if (!this.periodic && this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }

        public synchronized TimeoutStream fetch(long amount) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            return this;
        }

        public TimeoutStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        public void cancel() {
            if (this.id != null) {
                VertxImpl.this.cancelTimer(this.id);
            }
        }

        public synchronized TimeoutStream handler(Handler<Long> handler) {
            if (handler != null) {
                if (this.id != null) {
                    throw new IllegalStateException();
                }
                this.handler = handler;
                this.id = VertxImpl.this.scheduleTimeout(VertxImpl.this.getOrCreateContext(), (Handler<Long>)this, this.delay, this.periodic);
            } else {
                this.cancel();
            }
            return this;
        }

        public synchronized TimeoutStream pause() {
            this.demand = 0L;
            return this;
        }

        public synchronized TimeoutStream resume() {
            this.demand = Long.MAX_VALUE;
            return this;
        }

        public synchronized TimeoutStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }
    }

    private class InternalTimerHandler
    implements Handler<Void>,
    Closeable {
        final Handler<Long> handler;
        final boolean periodic;
        final long timerID;
        final ContextImpl context;
        final java.util.concurrent.Future<?> future;
        final AtomicBoolean cancelled;

        boolean cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                if (VertxImpl.this.metrics != null) {
                    VertxImpl.this.metrics.timerEnded(this.timerID, true);
                }
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        InternalTimerHandler(long timerID, Handler<Long> runnable, boolean periodic, long delay, ContextImpl context) {
            this.context = context;
            this.timerID = timerID;
            this.handler = runnable;
            this.periodic = periodic;
            this.cancelled = new AtomicBoolean();
            EventLoop el = context.nettyEventLoop();
            Runnable toRun = () -> context.runOnContext((Handler)this);
            this.future = periodic ? el.scheduleAtFixedRate(toRun, delay, delay, TimeUnit.MILLISECONDS) : el.schedule(toRun, delay, TimeUnit.MILLISECONDS);
            if (VertxImpl.this.metrics != null) {
                VertxImpl.this.metrics.timerCreated(timerID);
            }
        }

        public void handle(Void v) {
            if (!this.cancelled.get()) {
                try {
                    this.handler.handle((Object)this.timerID);
                }
                finally {
                    if (!this.periodic) {
                        this.cleanupNonPeriodic();
                    }
                }
            }
        }

        private void cleanupNonPeriodic() {
            ContextImpl context;
            VertxImpl.this.timeouts.remove(this.timerID);
            if (VertxImpl.this.metrics != null) {
                VertxImpl.this.metrics.timerEnded(this.timerID, false);
            }
            if ((context = VertxImpl.this.getContext()) != null) {
                context.removeCloseHook((Closeable)this);
            }
        }

        public void close(Handler<AsyncResult<Void>> completionHandler) {
            VertxImpl.this.timeouts.remove(this.timerID);
            this.cancel();
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }
}

