/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.ReifyingAllocator;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.util.PhantomReferenceReaper;
import org.jruby.util.cli.Options;

@JRubyClass(name={"FFI::AutoPointer"}, parent="FFI::Pointer")
public class AutoPointer
extends Pointer {
    static final String AUTOPTR_CLASS_NAME = "AutoPointer";
    private static final ConcurrentMap<ReaperGroup, Boolean> referenceSet = new ConcurrentHashMap<ReaperGroup, Boolean>();
    private static final ThreadLocal<Reference<ReaperGroup>> currentReaper = new ThreadLocal();
    private Pointer pointer;
    private Object referent;
    private volatile transient Reaper reaper;

    public static RubyClass createAutoPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass autoptrClass = module.defineClassUnder(AUTOPTR_CLASS_NAME, module.getClass("Pointer"), (Boolean)Options.REIFY_FFI.load() != false ? new ReifyingAllocator(AutoPointer.class) : AutoPointerAllocator.INSTANCE);
        autoptrClass.defineAnnotatedMethods(AutoPointer.class);
        autoptrClass.defineAnnotatedConstants(AutoPointer.class);
        autoptrClass.setReifiedClass(AutoPointer.class);
        autoptrClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof AutoPointer && super.isKindOf(obj, type2);
            }
        };
        return autoptrClass;
    }

    public AutoPointer(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz, runtime2.getFFI().getNullMemoryIO());
    }

    private static final void checkPointer(Ruby runtime2, IRubyObject ptr) {
        if (!(ptr instanceof Pointer)) {
            throw runtime2.newTypeError(ptr, runtime2.getFFI().pointerClass);
        }
        if (ptr instanceof MemoryPointer || ptr instanceof AutoPointer) {
            throw runtime2.newTypeError("Cannot use AutoPointer with MemoryPointer or AutoPointer instances");
        }
    }

    @JRubyMethod(name={"from_native"}, meta=true)
    public static IRubyObject from_native(ThreadContext context, IRubyObject recv2, IRubyObject value2, IRubyObject ctx) {
        return ((RubyClass)recv2).newInstance(context, value2, Block.NULL_BLOCK);
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg) {
        Ruby runtime2 = context.runtime;
        AutoPointer.checkPointer(runtime2, pointerArg);
        Object ffiHandle = this.getMetaClass().getFFIHandle();
        if (!(ffiHandle instanceof ClassData)) {
            ffiHandle = new ClassData();
            this.getMetaClass().setFFIHandle(ffiHandle);
        }
        ClassData classData = (ClassData)ffiHandle;
        DynamicMethod releaseMethod = ((ClassData)classData).releaseCallSite.retrieveCache((RubyClass)this.getMetaClass().getMetaClass(), (String)((ClassData)classData).releaseCallSite.getMethodName()).method;
        if (releaseMethod.isUndefined()) {
            throw runtime2.newRuntimeError("release method undefined");
        }
        if (releaseMethod.getArity().isFixed() && releaseMethod.getArity().required() != 1 || releaseMethod.getArity().required() > 1) {
            throw runtime2.newRuntimeError("wrong number of arguments to release method (1 for " + releaseMethod.getArity().required() + ")");
        }
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        this.size = this.pointer.size;
        this.typeSize = this.pointer.typeSize;
        this.setReaper(new Reaper(this.pointer, this.getMetaClass(), classData.releaseCallSite));
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg, IRubyObject releaser) {
        AutoPointer.checkPointer(context.runtime, pointerArg);
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        this.size = this.pointer.size;
        this.typeSize = this.pointer.typeSize;
        Object ffiHandle = releaser.getMetaClass().getFFIHandleAccessorField().getVariableAccessorForRead().get(releaser);
        if (!(ffiHandle instanceof ReleaserData)) {
            ffiHandle = new ReleaserData();
            this.getMetaClass().setFFIHandle(ffiHandle);
        }
        ReleaserData releaserData = (ReleaserData)ffiHandle;
        DynamicMethod releaseMethod = ((ReleaserData)releaserData).releaseCallSite.retrieveCache((RubyClass)releaser.getMetaClass(), (String)((ReleaserData)releaserData).releaseCallSite.getMethodName()).method;
        if (releaseMethod.isUndefined()) {
            throw context.runtime.newRuntimeError("call method undefined");
        }
        if (releaseMethod.getArity().isFixed() && releaseMethod.getArity().required() != 1 || releaseMethod.getArity().required() > 1) {
            throw context.runtime.newRuntimeError("wrong number of arguments to call method (1 for " + releaseMethod.getArity().required() + ")");
        }
        this.setReaper(new Reaper(this.pointer, releaser, releaserData.releaseCallSite));
        return this;
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        Reaper r = this.reaper;
        if (r == null || r.released) {
            throw context.runtime.newRuntimeError("pointer already freed");
        }
        r.release(context);
        this.reaper = null;
        this.referent = null;
        return context.nil;
    }

    @JRubyMethod(name={"autorelease="})
    public final IRubyObject autorelease(ThreadContext context, IRubyObject autorelease2) {
        Reaper r = this.reaper;
        if (r == null || r.released) {
            throw context.runtime.newRuntimeError("pointer already freed");
        }
        r.autorelease(autorelease2.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"autorelease?"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return context.runtime.newBoolean(this.reaper != null ? !this.reaper.unmanaged : false);
    }

    private void setReaper(Reaper reaper) {
        Object referent;
        Reference<ReaperGroup> reaperGroupReference = currentReaper.get();
        ReaperGroup reaperGroup = reaperGroupReference != null ? reaperGroupReference.get() : null;
        Object object = referent = reaperGroup != null ? reaperGroup.referent() : null;
        if (referent == null || !reaperGroup.canAccept()) {
            referent = new Object();
            reaperGroup = new ReaperGroup(referent);
            currentReaper.set(new SoftReference<ReaperGroup>(reaperGroup));
            referenceSet.put(reaperGroup, Boolean.TRUE);
        }
        this.referent = referent;
        this.reaper = reaper;
        reaperGroup.add(reaper);
    }

    private static final class ReleaserData {
        private final CachingCallSite releaseCallSite = new FunctionalCachingCallSite("call");

        private ReleaserData() {
        }
    }

    private static final class ClassData {
        private final CachingCallSite releaseCallSite = new FunctionalCachingCallSite("release");

        private ClassData() {
        }
    }

    private static final class Reaper {
        final Pointer pointer;
        final IRubyObject proc;
        final CachingCallSite callSite;
        volatile Reaper next;
        volatile boolean released;
        volatile boolean unmanaged;

        private Reaper(Pointer ptr, IRubyObject proc2, CachingCallSite callSite) {
            this.pointer = ptr;
            this.proc = proc2;
            this.callSite = callSite;
        }

        final Ruby getRuntime() {
            return this.proc.getRuntime();
        }

        void dispose(ThreadContext context) {
            this.callSite.call(context, this.proc, this.proc, (IRubyObject)this.pointer);
        }

        public final void release(ThreadContext context) {
            if (!this.released) {
                this.released = true;
                this.dispose(context);
            }
        }

        public final void autorelease(boolean autorelease2) {
            this.unmanaged = !autorelease2;
        }
    }

    private static final class ReaperGroup
    extends PhantomReferenceReaper<Object>
    implements Runnable {
        private static int MAX_REAPERS_PER_GROUP = 100;
        private final WeakReference<Object> weakref;
        private int reaperCount;
        private volatile Reaper head;

        ReaperGroup(Object referent) {
            super(referent);
            this.weakref = new WeakReference<Object>(referent);
        }

        Object referent() {
            return this.weakref.get();
        }

        boolean canAccept() {
            return this.reaperCount < MAX_REAPERS_PER_GROUP;
        }

        void add(Reaper r) {
            ++this.reaperCount;
            r.next = this.head;
            this.head = r;
        }

        @Override
        public void run() {
            referenceSet.remove(this);
            Ruby runtime2 = null;
            ThreadContext ctx = null;
            Reaper r = this.head;
            while (r != null) {
                if (!r.released && !r.unmanaged) {
                    if (r.getRuntime() != runtime2) {
                        runtime2 = r.getRuntime();
                        ctx = runtime2.getCurrentContext();
                    }
                    r.dispose(ctx);
                }
                r = r.next;
            }
        }
    }

    private static final class AutoPointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new AutoPointerAllocator();

        private AutoPointerAllocator() {
        }

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new AutoPointer(runtime2, klazz);
        }
    }
}

