/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.netflix.config.DynamicPropertyFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CookieHandler;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.AbstractRestInvocation;
import org.apache.servicecomb.common.rest.VertxRestInvocation;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.AbstractVertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxRestDispatcher
extends AbstractVertxHttpDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRestDispatcher.class);
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.rest.enabled";
    private Transport transport;

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, true).get();
    }

    @Override
    public void init(Router router) {
        router.route().handler((Handler)CookieHandler.create());
        router.route().handler((Handler)this.createBodyHandler());
        router.route().failureHandler(this::failureHandler).handler(this::onRequest);
    }

    protected void failureHandler(RoutingContext context) {
        Throwable cause;
        LOGGER.error("http server failed.", context.failure());
        AbstractRestInvocation restProducerInvocation = (AbstractRestInvocation)context.get("servicecomb-rest-producer-invocation");
        Throwable e = context.failure();
        if (HttpPostRequestDecoder.ErrorDataDecoderException.class.isInstance(e) && InvocationException.class.isInstance(cause = e.getCause())) {
            e = cause;
        }
        this.handleFailureAndClose(context, restProducerInvocation, e);
    }

    private void handleFailureAndClose(RoutingContext context, AbstractRestInvocation restProducerInvocation, Throwable e) {
        if (null != restProducerInvocation) {
            this.sendFailResponseByInvocation(context, restProducerInvocation, e);
            return;
        }
        if (null != e) {
            this.sendExceptionByRoutingContext(context, e);
            return;
        }
        this.sendFailureRespDeterminedByStatus(context);
    }

    private void sendFailureRespDeterminedByStatus(RoutingContext context) {
        Response.Status.Family statusFamily = Response.Status.Family.familyOf((int)context.statusCode());
        if (Response.Status.Family.CLIENT_ERROR.equals((Object)statusFamily) || Response.Status.Family.SERVER_ERROR.equals((Object)statusFamily) || Response.Status.Family.OTHER.equals((Object)statusFamily)) {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(context.statusCode()).end();
        } else {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setStatusMessage(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).end(this.wrapResponseBody(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        }
        context.response().close();
    }

    private void sendExceptionByRoutingContext(RoutingContext context, Throwable e) {
        if (InvocationException.class.isInstance(e)) {
            InvocationException invocationException = (InvocationException)e;
            context.response().putHeader("Content-Type", "*/*").setStatusCode(invocationException.getStatusCode()).setStatusMessage(invocationException.getReasonPhrase()).end(this.wrapResponseBody(invocationException.getReasonPhrase()));
        } else {
            context.response().putHeader("Content-Type", "*/*").setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).end(this.wrapResponseBody(e.getMessage()));
        }
        context.response().close();
    }

    String wrapResponseBody(String message) {
        if (this.isValidJson(message)) {
            return message;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("message", message);
        return jsonObject.toString();
    }

    private boolean isValidJson(String message) {
        try {
            new JsonObject(message);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    private void sendFailResponseByInvocation(RoutingContext context, AbstractRestInvocation restProducerInvocation, Throwable e) {
        restProducerInvocation.sendFailResponse(e);
        context.response().close();
    }

    protected void onRequest(RoutingContext context) {
        if (this.transport == null) {
            this.transport = CseContext.getInstance().getTransportManager().findTransport("rest");
        }
        VertxServerRequestToHttpServletRequest requestEx = new VertxServerRequestToHttpServletRequest(context);
        VertxServerResponseToHttpServletResponse responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        VertxRestInvocation vertxRestInvocation = new VertxRestInvocation();
        context.put("servicecomb-rest-producer-invocation", (Object)vertxRestInvocation);
        vertxRestInvocation.invoke(this.transport, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, this.httpServerFilters);
    }
}

