/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBStatus;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListenerManager;
import org.apache.servicecomb.core.definition.schema.StaticSchemaFactory;
import org.apache.servicecomb.core.endpoint.AbstractEndpointsCache;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.handler.HandlerConfigUtils;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.producer.ProducerProviderManager;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.log.LogMarkerLeakFixUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceRegisterTask;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SCBEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCBEngine.class);
    static final String CFG_KEY_WAIT_UP_TIMEOUT = "servicecomb.boot.waitUp.timeoutInMilliseconds";
    static final long DEFAULT_WAIT_UP_TIMEOUT = 10000L;
    private ProducerProviderManager producerProviderManager;
    private ConsumerProviderManager consumerProviderManager;
    private MicroserviceMeta producerMicroserviceMeta;
    private TransportManager transportManager;
    private SchemaListenerManager schemaListenerManager;
    private Collection<BootListener> bootListenerList;
    private final AtomicLong invocationStartedCounter = new AtomicLong();
    private final AtomicLong invocationFinishedCounter = new AtomicLong();
    private volatile SCBStatus status = SCBStatus.DOWN;
    private EventBus eventBus = EventManager.getEventBus();
    private StaticSchemaFactory staticSchemaFactory;
    private PriorityPropertyManager priorityPropertyManager = new PriorityPropertyManager();
    private static final SCBEngine INSTANCE = new SCBEngine();

    public void setStatus(SCBStatus status) {
        this.status = status;
    }

    public SCBStatus getStatus() {
        return this.status;
    }

    public static SCBEngine getInstance() {
        return INSTANCE;
    }

    public PriorityPropertyManager getPriorityPropertyManager() {
        return this.priorityPropertyManager;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setProducerProviderManager(ProducerProviderManager producerProviderManager) {
        this.producerProviderManager = producerProviderManager;
    }

    public void setConsumerProviderManager(ConsumerProviderManager consumerProviderManager) {
        this.consumerProviderManager = consumerProviderManager;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void setSchemaListenerManager(SchemaListenerManager schemaListenerManager) {
        this.schemaListenerManager = schemaListenerManager;
    }

    public Collection<BootListener> getBootListenerList() {
        return this.bootListenerList;
    }

    public void setBootListenerList(Collection<BootListener> bootListenerList) {
        ArrayList<BootListener> tmp = new ArrayList<BootListener>();
        tmp.addAll(bootListenerList);
        tmp.addAll(SPIServiceUtils.getOrLoadSortedService(BootListener.class));
        tmp.sort(Comparator.comparingInt(BootListener::getOrder));
        this.bootListenerList = tmp;
    }

    protected void triggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListenerList) {
            listener.onBootEvent(event);
        }
    }

    protected void safeTriggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListenerList) {
            try {
                listener.onBootEvent(event);
                LOGGER.info("BootListener {} succeed to process {}.", (Object)listener.getClass().getName(), (Object)eventType);
            }
            catch (Throwable e) {
                LOGGER.error("BootListener {} failed to process {}.", new Object[]{listener.getClass().getName(), eventType, e});
            }
        }
    }

    private void triggerAfterRegistryEvent() {
        EventManager.register((Object)new Object(){

            @Subscribe
            public void afterRegistryInstance(MicroserviceInstanceRegisterTask microserviceInstanceRegisterTask) {
                LOGGER.info("receive MicroserviceInstanceRegisterTask event, check instance Id...");
                if (!StringUtils.isEmpty((Object)RegistryUtils.getMicroserviceInstance().getInstanceId())) {
                    LOGGER.info("instance registry succeeds for the first time, will send AFTER_REGISTRY event.");
                    SCBEngine.this.status = SCBStatus.UP;
                    SCBEngine.this.triggerEvent(BootListener.EventType.AFTER_REGISTRY);
                    EventManager.unregister((Object)this);
                    LOGGER.info("ServiceComb is ready.");
                }
            }
        });
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationStart(InvocationStartEvent event) {
        this.invocationStartedCounter.incrementAndGet();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationFinish(InvocationFinishEvent event) {
        this.invocationFinishedCounter.incrementAndGet();
    }

    public synchronized void init() {
        if (SCBStatus.DOWN.equals((Object)this.status)) {
            try {
                this.doInit();
                this.waitStatusUp();
            }
            catch (TimeoutException e) {
                LOGGER.warn("{}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                try {
                    this.destroy();
                }
                catch (Exception exception) {
                    LOGGER.info("destroy has some error.", (Throwable)exception);
                }
                this.status = SCBStatus.FAILED;
                throw new IllegalStateException("ServiceComb init failed.", e);
            }
        }
    }

    private void doInit() throws Exception {
        this.status = SCBStatus.STARTING;
        LogMarkerLeakFixUtils.fix();
        this.eventBus.register((Object)this);
        this.consumerProviderManager.setAppManager(RegistryUtils.getServiceRegistry().getAppManager());
        AbstractEndpointsCache.init(RegistryUtils.getInstanceCacheManager(), this.transportManager);
        this.triggerEvent(BootListener.EventType.BEFORE_HANDLER);
        HandlerConfigUtils.init();
        this.triggerEvent(BootListener.EventType.AFTER_HANDLER);
        this.triggerEvent(BootListener.EventType.BEFORE_PRODUCER_PROVIDER);
        this.producerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_PRODUCER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_CONSUMER_PROVIDER);
        this.consumerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_CONSUMER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_TRANSPORT);
        this.transportManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_TRANSPORT);
        this.schemaListenerManager.notifySchemaListener();
        this.triggerEvent(BootListener.EventType.BEFORE_REGISTRY);
        this.triggerAfterRegistryEvent();
        RegistryUtils.run();
        Runtime.getRuntime().addShutdownHook(new Thread(this::destroy));
    }

    public synchronized void destroy() {
        if (SCBStatus.UP.equals((Object)this.status) || SCBStatus.STARTING.equals((Object)this.status)) {
            LOGGER.info("ServiceComb is closing now...");
            this.doDestroy();
            this.status = SCBStatus.DOWN;
            LOGGER.info("ServiceComb had closed");
        }
    }

    private void doDestroy() {
        this.safeTriggerEvent(BootListener.EventType.BEFORE_CLOSE);
        this.status = SCBStatus.STOPPING;
        RegistryUtils.destroy();
        VertxUtils.blockCloseVertxByName((String)"registry");
        try {
            this.validAllInvocationFinished();
        }
        catch (InterruptedException e) {
            LOGGER.error("wait all invocation finished interrupted", (Throwable)e);
        }
        VertxUtils.blockCloseVertxByName((String)"config-center");
        VertxUtils.blockCloseVertxByName((String)"transport");
        ConfigUtil.destroyConfigCenterConfigurationSource();
        this.priorityPropertyManager.close();
        this.safeTriggerEvent(BootListener.EventType.AFTER_CLOSE);
    }

    private void validAllInvocationFinished() throws InterruptedException {
        long start = System.currentTimeMillis();
        long remaining;
        while ((remaining = this.invocationStartedCounter.get() - this.invocationFinishedCounter.get()) != 0L) {
            if (System.currentTimeMillis() - start > TimeUnit.SECONDS.toMillis(30L)) {
                LOGGER.error("wait for all requests timeout, abandon waiting, remaining requests: {}.", (Object)remaining);
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return;
    }

    public void ensureStatusUp() {
        SCBStatus currentStatus = this.getStatus();
        if (!SCBStatus.UP.equals((Object)currentStatus)) {
            String message = "The request is rejected. Cannot process the request due to STATUS = " + (Object)((Object)currentStatus);
            LOGGER.warn(message);
            throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, message);
        }
    }

    public ReferenceConfig createReferenceConfigForInvoke(String microserviceName, String versionRule, String transport) {
        this.ensureStatusUp();
        return this.consumerProviderManager.createReferenceConfig(microserviceName, versionRule, transport);
    }

    public ReferenceConfig getReferenceConfigForInvoke(String microserviceName) {
        this.ensureStatusUp();
        return this.consumerProviderManager.getReferenceConfig(microserviceName);
    }

    public MicroserviceMeta getProducerMicroserviceMeta() {
        return this.producerMicroserviceMeta;
    }

    public void setProducerMicroserviceMeta(MicroserviceMeta producerMicroserviceMeta) {
        this.producerMicroserviceMeta = producerMicroserviceMeta;
    }

    public void waitStatusUp() throws InterruptedException, TimeoutException {
        long msWait = DynamicPropertyFactory.getInstance().getLongProperty(CFG_KEY_WAIT_UP_TIMEOUT, 10000L).get();
        this.waitStatusUp(msWait);
    }

    public void waitStatusUp(long msWait) throws InterruptedException, TimeoutException {
        SCBStatus currentStatus;
        if (msWait <= 0L) {
            LOGGER.info("Give up waiting for status up, wait timeout milliseconds={}.", (Object)msWait);
            return;
        }
        LOGGER.info("Waiting for status up. timeout: {}ms", (Object)msWait);
        long start = System.currentTimeMillis();
        do {
            currentStatus = this.getStatus();
            switch (currentStatus) {
                case DOWN: 
                case FAILED: {
                    throw new IllegalStateException("Failed to wait status up, real status: " + (Object)((Object)currentStatus));
                }
                case UP: {
                    LOGGER.info("Status already changed to up.");
                    return;
                }
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        } while (System.currentTimeMillis() - start <= msWait);
        throw new TimeoutException(String.format("Timeout to wait status up, timeout: %dms, last status: %s", new Object[]{msWait, currentStatus}));
    }

    public StaticSchemaFactory getStaticSchemaFactory() {
        return this.staticSchemaFactory;
    }

    public void setStaticSchemaFactory(StaticSchemaFactory staticSchemaFactory) {
        this.staticSchemaFactory = staticSchemaFactory;
    }
}

