/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.util.Pair;

public class Server {
    public static final String UNKNOWN_ZONE = "UNKNOWN";
    private String host;
    private int port = 80;
    private String scheme;
    private volatile String id;
    private volatile boolean isAliveFlag;
    private String zone = "UNKNOWN";
    private volatile boolean readyToServe = true;
    private MetaInfo simpleMetaInfo = new MetaInfo(){

        @Override
        public String getAppName() {
            return null;
        }

        @Override
        public String getServerGroup() {
            return null;
        }

        @Override
        public String getServiceIdForDiscovery() {
            return null;
        }

        @Override
        public String getInstanceId() {
            return Server.this.id;
        }
    };

    public Server(String host, int port) {
        this(null, host, port);
    }

    public Server(String scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.id = host + ":" + port;
        this.isAliveFlag = false;
    }

    public Server(String id) {
        this.setId(id);
        this.isAliveFlag = false;
    }

    public void setAlive(boolean isAliveFlag) {
        this.isAliveFlag = isAliveFlag;
    }

    public boolean isAlive() {
        return this.isAliveFlag;
    }

    @Deprecated
    public void setHostPort(String hostPort) {
        this.setId(hostPort);
    }

    public static String normalizeId(String id) {
        Pair<String, Integer> hostPort = Server.getHostPort(id);
        if (hostPort == null) {
            return null;
        }
        return (String)hostPort.first() + ":" + hostPort.second();
    }

    private static String getScheme(String id) {
        if (id != null) {
            if (id.toLowerCase().startsWith("http://")) {
                return "http";
            }
            if (id.toLowerCase().startsWith("https://")) {
                return "https";
            }
        }
        return null;
    }

    static Pair<String, Integer> getHostPort(String id) {
        if (id != null) {
            int colon_idx;
            String host = null;
            int port = 80;
            if (id.toLowerCase().startsWith("http://")) {
                id = id.substring(7);
            } else if (id.toLowerCase().startsWith("https://")) {
                id = id.substring(8);
            }
            if (id.contains("/")) {
                int slash_idx = id.indexOf("/");
                id = id.substring(0, slash_idx);
            }
            if ((colon_idx = id.indexOf(58)) == -1) {
                host = id;
                port = 80;
            } else {
                host = id.substring(0, colon_idx);
                port = Integer.parseInt(id.substring(colon_idx + 1));
            }
            return new Pair((Object)host, (Object)port);
        }
        return null;
    }

    public void setId(String id) {
        Pair<String, Integer> hostPort = Server.getHostPort(id);
        if (hostPort != null) {
            this.id = (String)hostPort.first() + ":" + hostPort.second();
            this.host = (String)hostPort.first();
            this.port = (Integer)hostPort.second();
            this.scheme = Server.getScheme(id);
        } else {
            this.id = null;
        }
    }

    public void setSchemea(String scheme) {
        this.scheme = scheme;
    }

    public void setPort(int port) {
        this.port = port;
        if (this.host != null) {
            this.id = this.host + ":" + port;
        }
    }

    public void setHost(String host) {
        if (host != null) {
            this.host = host;
            this.id = host + ":" + this.port;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHostPort() {
        return this.host + ":" + this.port;
    }

    public MetaInfo getMetaInfo() {
        return this.simpleMetaInfo;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server svc = (Server)obj;
        return svc.getId().equals(this.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.getId() ? 0 : this.getId().hashCode());
        return hash;
    }

    public final String getZone() {
        return this.zone;
    }

    public final void setZone(String zone) {
        this.zone = zone;
    }

    public final boolean isReadyToServe() {
        return this.readyToServe;
    }

    public final void setReadyToServe(boolean readyToServe) {
        this.readyToServe = readyToServe;
    }

    public static interface MetaInfo {
        public String getAppName();

        public String getServerGroup();

        public String getServiceIdForDiscovery();

        public String getInstanceId();
    }
}

