/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InternMap<K, V> {
    private final ConcurrentMap<K, V> storage = new ConcurrentHashMap();
    private final ValueConstructor<K, V> valueConstructor;

    public InternMap(ValueConstructor<K, V> valueConstructor) {
        this.valueConstructor = valueConstructor;
    }

    public V interned(K key) {
        Object existingKey = this.storage.get(key);
        Object newKey = null;
        if (existingKey == null) {
            newKey = this.valueConstructor.create(key);
            existingKey = this.storage.putIfAbsent(key, newKey);
        }
        return existingKey != null ? existingKey : newKey;
    }

    public int size() {
        return this.storage.size();
    }

    public static interface ValueConstructor<K, V> {
        public V create(K var1);
    }
}

