/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.spectator.servo.ServoPollers;
import com.netflix.spectator.servo.StepLong;
import java.util.concurrent.atomic.AtomicLong;

class DoubleCounter
extends AbstractMonitor<Number>
implements NumericMonitor<Number> {
    private final StepLong count;

    DoubleCounter(MonitorConfig config) {
        this(config, (Clock)ClockWithOffset.INSTANCE);
    }

    DoubleCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag((Tag)DataSourceType.NORMALIZED));
        this.count = new StepLong(0L, clock);
    }

    private void add(AtomicLong num, double amount) {
        double d;
        long next;
        long v;
        while (!num.compareAndSet(v = num.get(), next = Double.doubleToLongBits((d = Double.longBitsToDouble(v)) + amount))) {
        }
    }

    void increment(double amount) {
        if (amount >= 0.0) {
            for (int i = 0; i < ServoPollers.NUM_POLLERS; ++i) {
                this.add(this.count.getCurrent(i), amount);
            }
        }
    }

    public Number getValue(int pollerIndex) {
        Long dp = this.count.poll(pollerIndex);
        double stepSeconds = (double)ServoPollers.POLLING_INTERVALS[pollerIndex] / 1000.0;
        return dp == null ? Double.NaN : Double.longBitsToDouble(dp) / stepSeconds;
    }

    public String toString() {
        return "DoubleCounter(config=" + this.config + ",count=" + this.getValue() + ")";
    }
}

