/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.authentication.RSAAuthenticationToken;
import org.apache.servicecomb.authentication.provider.AccessController;
import org.apache.servicecomb.foundation.common.utils.RSAUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.cache.MicroserviceInstanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAProviderTokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAProviderTokenManager.class);
    private Set<RSAAuthenticationToken> validatedToken = ConcurrentHashMap.newKeySet(1000);
    private AccessController accessController = new AccessController();

    public boolean valid(String token) {
        try {
            RSAAuthenticationToken rsaToken = RSAAuthenticationToken.fromStr(token);
            if (null == rsaToken) {
                LOGGER.error("token format is error, perhaps you need to set auth handler at consumer");
                return false;
            }
            if (this.tokenExprired(rsaToken)) {
                LOGGER.error("token is expired");
                return false;
            }
            if (this.validatedToken.contains(rsaToken)) {
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            String sign = rsaToken.getSign();
            String content = rsaToken.plainToken();
            String publicKey = this.getPublicKey(rsaToken.getInstanceId(), rsaToken.getServiceId());
            boolean verify = RSAUtils.verify((String)publicKey, (String)sign, (String)content);
            if (verify && !this.tokenExprired(rsaToken)) {
                this.validatedToken.add(rsaToken);
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            LOGGER.error("verfiy error", (Throwable)e);
            return false;
        }
    }

    private boolean tokenExprired(RSAAuthenticationToken rsaToken) {
        long generateTime = rsaToken.getGenerateTime();
        long expired = generateTime + 86400000L + 900000L;
        long now = System.currentTimeMillis();
        return now > expired;
    }

    private String getPublicKey(String instanceId, String serviceId) {
        MicroserviceInstance instances = MicroserviceInstanceCache.getOrCreate((String)serviceId, (String)instanceId);
        if (instances != null) {
            return (String)instances.getProperties().get("publickey");
        }
        LOGGER.error("not instance found {}-{}, maybe attack", (Object)instanceId, (Object)serviceId);
        return "";
    }
}

