/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.AbstractVertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdgeDispatcher
extends AbstractVertxHttpDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEdgeDispatcher.class);

    protected void onFailure(RoutingContext context) {
        LOGGER.error("edge server failed.", context.failure());
        HttpServerResponse response = context.response();
        if (context.failure() instanceof InvocationException) {
            InvocationException exception = (InvocationException)context.failure();
            response.setStatusCode(exception.getStatusCode());
            response.setStatusMessage(exception.getErrorData().toString());
            response.end();
        } else {
            response.setStatusCode(Response.Status.BAD_GATEWAY.getStatusCode());
            response.setStatusMessage(Response.Status.BAD_GATEWAY.getReasonPhrase());
            response.end();
        }
    }
}

