/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.loadbalancer.LoadBalancerStats;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancer.class);
    private static AtomicInteger id = new AtomicInteger(0);
    private RuleExt rule;
    private LoadBalancerStats lbStats;
    private String microServiceName;
    private List<ServerListFilterExt> filters;

    public LoadBalancer(RuleExt rule, String microServiceName) {
        this.microServiceName = microServiceName;
        this.rule = rule;
        this.lbStats = new LoadBalancerStats(microServiceName + id.getAndDecrement());
        this.filters = SPIServiceUtils.loadSortedService(ServerListFilterExt.class);
        this.rule.setLoadBalancer(this);
        this.filters.forEach(item -> item.setLoadBalancer(this));
    }

    public ServiceCombServer chooseServer(Invocation invocation) {
        List<ServiceCombServer> servers = (List<ServiceCombServer>)invocation.getLocalContext("x-context-server-list");
        int serversCount = servers.size();
        for (ServerListFilterExt filterExt : this.filters) {
            servers = filterExt.getFilteredListOfServers(servers, invocation);
            if (!servers.isEmpty() || serversCount <= 0) continue;
            LOGGER.warn("There are not servers exist after filtered by {}.", filterExt.getClass());
            break;
        }
        return this.rule.choose(servers, invocation);
    }

    public LoadBalancerStats getLoadBalancerStats() {
        return this.lbStats;
    }

    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @VisibleForTesting
    void setFilters(List<ServerListFilterExt> filters) {
        this.filters = filters;
    }
}

