/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.netflix.config.Property;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.servicecomb.config.priority.impl.PropertyGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PriorityProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityProperty.class);
    private final String[] priorityKeys;
    private final String joinedPriorityKeys;
    private final T invalidValue;
    private final T defaultValue;
    private Property<T>[] properties;
    private T finalValue;
    private Consumer<T> callback = v -> {};

    public PriorityProperty(T invalidValue, T defaultValue, PropertyGetter<T> propertyGetter, String ... priorityKeys) {
        this.priorityKeys = priorityKeys;
        this.joinedPriorityKeys = Arrays.toString(priorityKeys);
        this.invalidValue = invalidValue;
        this.defaultValue = defaultValue;
        this.properties = (Property[])Array.newInstance(Property.class, priorityKeys.length);
        for (int idx = 0; idx < priorityKeys.length; ++idx) {
            String key = priorityKeys[idx].trim();
            this.properties[idx] = propertyGetter.getProperty(key, invalidValue);
            this.properties[idx].addCallback(() -> this.updateFinalValue(false));
        }
        this.updateFinalValue(true);
    }

    public String[] getPriorityKeys() {
        return this.priorityKeys;
    }

    private synchronized void updateFinalValue(boolean init) {
        String effectiveKey = "default value";
        Object value = this.defaultValue;
        for (Property<T> property : this.properties) {
            if (property.getValue() == null || property.getValue().equals(this.invalidValue)) continue;
            effectiveKey = property.getName();
            value = property.getValue();
            break;
        }
        if (init) {
            LOGGER.debug("config inited, \"{}\" set to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, value, effectiveKey});
        } else {
            LOGGER.info("config changed, \"{}\" changed from {} to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, this.finalValue, value, effectiveKey});
        }
        this.finalValue = value;
        this.callback.accept(this.finalValue);
    }

    public T getValue() {
        return this.finalValue;
    }

    public void setCallback(Consumer<T> callback) {
        this.callback = callback;
        callback.accept(this.finalValue);
    }
}

