/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.inject;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.inject.InjectProperty;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.impl.BooleanPriorityProperty;
import org.apache.servicecomb.config.priority.impl.DoublePriorityProperty;
import org.apache.servicecomb.config.priority.impl.FloatPriorityProperty;
import org.apache.servicecomb.config.priority.impl.IntPriorityProperty;
import org.apache.servicecomb.config.priority.impl.LongPriorityProperty;
import org.apache.servicecomb.config.priority.impl.StringPriorityProperty;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;

public class ConfigObjectFactory {
    private Class<?> cls;
    private Map<String, Object> parameters;
    private Object instance;
    private String prefix = "";

    public <T> T create(Class<T> cls, Object ... kvs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int idx = 0; idx < kvs.length; idx += 2) {
            parameters.put(kvs[idx].toString(), kvs[idx + 1]);
        }
        return this.create(cls, parameters);
    }

    public <T> T create(Class<T> cls, Map<String, Object> parameters) {
        this.cls = cls;
        this.parameters = parameters;
        try {
            this.instance = cls.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException("create config object failed, class=" + cls.getName(), e);
        }
        this.initPrefix();
        this.doCreate();
        return (T)this.instance;
    }

    private void initPrefix() {
        InjectProperties injectProperties = this.cls.getAnnotation(InjectProperties.class);
        if (injectProperties == null) {
            return;
        }
        String prefix = injectProperties.prefix();
        if (!prefix.isEmpty()) {
            this.prefix = prefix + ".";
        }
    }

    private void doCreate() {
        JavaType javaType = TypeFactory.defaultInstance().constructType(this.cls);
        BeanDescription beanDescription = JsonUtils.OBJ_MAPPER.getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
            if (propertyDefinition.getField() == null || propertyDefinition.getSetter() == null && !propertyDefinition.getField().isPublic()) continue;
            Setter setter = propertyDefinition.getSetter() == null ? LambdaMetafactoryUtils.createSetter((Field)propertyDefinition.getField().getAnnotated()) : (Setter)LambdaMetafactoryUtils.createLambda((Method)propertyDefinition.getSetter().getAnnotated(), Setter.class);
            this.createPriorityProperty(propertyDefinition.getField().getAnnotated()).setCallback(value -> setter.set(this.instance, value));
        }
    }

    private PriorityProperty<?> createPriorityProperty(Field field) {
        String[] keys = this.collectPropertyKeys(field);
        Class<?> fieldCls = field.getType();
        switch (fieldCls.getName()) {
            case "int": {
                return this.createIntProperty(field, keys, 0);
            }
            case "java.lang.Integer": {
                return this.createIntProperty(field, keys, null);
            }
            case "long": {
                return this.createLongProperty(field, keys, 0L);
            }
            case "java.lang.Long": {
                return this.createLongProperty(field, keys, null);
            }
            case "java.lang.String": {
                return this.createStringProperty(field, keys);
            }
            case "float": {
                return this.createFloatProperty(field, keys, Float.valueOf(0.0f));
            }
            case "java.lang.Float": {
                return this.createFloatProperty(field, keys, null);
            }
            case "double": {
                return this.createDoubleProperty(field, keys, 0.0);
            }
            case "java.lang.Double": {
                return this.createDoubleProperty(field, keys, null);
            }
            case "boolean": {
                return this.createBooleanProperty(field, keys, false);
            }
            case "java.lang.Boolean": {
                return this.createBooleanProperty(field, keys, null);
            }
        }
        throw new IllegalStateException("not support, field=" + field);
    }

    private PriorityProperty<?> createStringProperty(Field field, String[] keys) {
        String defaultValue = null;
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = injectProperty.defaultValue();
        }
        return new StringPriorityProperty(null, defaultValue, keys);
    }

    private PriorityProperty<?> createDoubleProperty(Field field, String[] keys, Double defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Double.parseDouble(injectProperty.defaultValue());
        }
        return new DoublePriorityProperty(null, defaultValue, keys);
    }

    private PriorityProperty<?> createFloatProperty(Field field, String[] keys, Float defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Float.valueOf(Float.parseFloat(injectProperty.defaultValue()));
        }
        return new FloatPriorityProperty(null, defaultValue, keys);
    }

    private PriorityProperty<?> createBooleanProperty(Field field, String[] keys, Boolean defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Boolean.parseBoolean(injectProperty.defaultValue());
        }
        return new BooleanPriorityProperty(null, defaultValue, keys);
    }

    private PriorityProperty<?> createLongProperty(Field field, String[] keys, Long defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Long.parseLong(injectProperty.defaultValue());
        }
        return new LongPriorityProperty(null, defaultValue, keys);
    }

    private PriorityProperty<?> createIntProperty(Field field, String[] keys, Integer defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Integer.parseInt(injectProperty.defaultValue());
        }
        return new IntPriorityProperty(null, defaultValue, keys);
    }

    private String[] collectPropertyKeys(Field field) {
        String propertyPrefix = this.prefix;
        String[] keys = new String[]{field.getName()};
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null) {
            if (!injectProperty.prefix().isEmpty()) {
                propertyPrefix = injectProperty.prefix() + ".";
            }
            if (injectProperty.keys().length != 0) {
                keys = injectProperty.keys();
            }
        }
        ArrayList<String> finalKeys = new ArrayList<String>();
        for (String key : keys) {
            List<String> resolvedKeys = new PlaceholderResolver().replace(propertyPrefix + key, this.parameters);
            finalKeys.addAll(resolvedKeys);
        }
        return finalKeys.toArray(new String[finalKeys.size()]);
    }
}

