/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.parameter;

import io.swagger.converter.ModelConverters;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.core.DefaultParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.apache.servicecomb.swagger.generator.springmvc.processor.parameter.SpringmvcDefaultObjectParameterProcessor;
import org.apache.servicecomb.swagger.generator.springmvc.processor.parameter.SpringmvcDefaultSimpleParameterProcessor;

public class SpringmvcDefaultParameterProcessor
implements DefaultParameterProcessor {
    private SpringmvcDefaultSimpleParameterProcessor simpleParameterProcessor = new SpringmvcDefaultSimpleParameterProcessor();
    private SpringmvcDefaultObjectParameterProcessor objectParameterProcessor = new SpringmvcDefaultObjectParameterProcessor();

    public void process(OperationGenerator operationGenerator, int paramIdx) {
        Type paramType = ParamUtils.getGenericParameterType((Method)operationGenerator.getProviderMethod(), (int)paramIdx);
        Property property = ModelConverters.getInstance().readAsProperty(paramType);
        if (RefProperty.class.isInstance(property)) {
            this.objectParameterProcessor.process(operationGenerator, paramIdx);
            return;
        }
        if (!ParamUtils.isComplexProperty((Property)property)) {
            this.simpleParameterProcessor.process(operationGenerator, paramIdx);
            return;
        }
        String msg = String.format("cannot process parameter [%s], method=%s:%s, paramIdx=%d, type=%s", ParamUtils.getParameterName((Method)operationGenerator.getProviderMethod(), (int)paramIdx), operationGenerator.getProviderMethod().getDeclaringClass().getName(), operationGenerator.getProviderMethod().getName(), paramIdx, paramType.getTypeName());
        throw new Error(msg);
    }
}

