/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CompositeMonitorWrapper<T>
extends AbstractMonitor<T>
implements CompositeMonitor<T> {
    private final TagList tags;
    private final CompositeMonitor<T> monitor;

    public CompositeMonitorWrapper(TagList tags, CompositeMonitor<T> monitor) {
        super(monitor.getConfig().withAdditionalTags(tags));
        this.tags = tags;
        this.monitor = monitor;
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        List<Monitor<?>> monitors = this.monitor.getMonitors();
        ArrayList wrappedMonitors = new ArrayList(monitors.size());
        for (Monitor<?> m : monitors) {
            wrappedMonitors.add(Monitors.wrap(this.tags, m));
        }
        return Collections.unmodifiableList(wrappedMonitors);
    }

    @Override
    public T getValue(int pollerIdx) {
        return this.monitor.getValue(pollerIdx);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompositeMonitorWrapper)) {
            return false;
        }
        CompositeMonitorWrapper m = (CompositeMonitorWrapper)obj;
        return this.config.equals(m.getConfig()) && this.monitor.equals(m.monitor);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.monitor.hashCode();
        return result;
    }

    public String toString() {
        return "CompositeMonitorWrapper{config=" + this.config + ", monitor=" + this.monitor + '}';
    }
}

