/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.Property;
import java.util.List;
import org.apache.servicecomb.codec.protobuf.internal.converter.SwaggerTypeAdapter;

public class ModelAdapter
implements SwaggerTypeAdapter {
    private final Model model;

    public ModelAdapter(Model model) {
        this.model = model;
    }

    @Override
    public String getRefType() {
        if (this.model instanceof RefModel) {
            return ((RefModel)this.model).getSimpleRef();
        }
        return null;
    }

    @Override
    public Property getArrayItem() {
        if (this.model instanceof ArrayModel) {
            return ((ArrayModel)this.model).getItems();
        }
        return null;
    }

    @Override
    public Property getMapItem() {
        if (this.model instanceof ModelImpl) {
            return ((ModelImpl)this.model).getAdditionalProperties();
        }
        return null;
    }

    @Override
    public List<String> getEnum() {
        if (this.model instanceof ModelImpl) {
            return ((ModelImpl)this.model).getEnum();
        }
        return null;
    }

    @Override
    public String getType() {
        if (this.model instanceof ModelImpl) {
            return ((ModelImpl)this.model).getType();
        }
        return null;
    }

    @Override
    public String getFormat() {
        if (this.model instanceof ModelImpl) {
            return ((ModelImpl)this.model).getFormat();
        }
        return null;
    }

    @Override
    public boolean isJavaLangObject() {
        if (this.model instanceof ModelImpl) {
            ModelImpl modelImpl = (ModelImpl)this.model;
            return "object".equals(modelImpl.getType()) && modelImpl.getProperties() == null && modelImpl.getName() == null;
        }
        return false;
    }
}

