////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package mx.charts.chartClasses
{

/**
 *  A bounded value is used to represent a datapoint
 *  that a chart element intends to render on screen.
 *  ChartElements report BoundedValues, describing their data
 *  to an Axis object. The axis computes autogenerated ranges.
 *  A BoundedValue encapsulates both the value of the datapoint
 *  in a particualr dimension, as well as a margin, in pixels,
 *  that a ChartElement needs above or below the value
 *  in order to render it.
 *  Plots on a plot chart, for example, report their data
 *  with margins to accomodate the size of the plots.
 *  A column chart might report a margin in the Y axis
 *  to accomodate a label rendered above the chart.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
public class BoundedValue
{
//    include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Constructor
	//
	//--------------------------------------------------------------------------

	/**
	 *  Constructor.
	 *
	 *  @param value The value to be rendered.
	 *
	 *  @param lowerMargin The lower margin.
	 *
	 *  @param upperMargin The upper margin.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public function BoundedValue(value:Number,
								 lowerMargin:Number = 0,
								 upperMargin:Number = 0)
	{
		super();

		this.value = value;
		this.lowerMargin = lowerMargin;
		this.upperMargin = upperMargin;
	}

	//--------------------------------------------------------------------------
	//
	//  Properties
	//
	//--------------------------------------------------------------------------

	//----------------------------------
	//  lowerMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The margin, in pixels, required below the value
	 *  in order to render properly.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var lowerMargin:Number;

	//----------------------------------
	//  upperMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/** 
	 *  The margin, in pixels, required above the value
	 *  in order to render properly.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var upperMargin:Number;
	
	//----------------------------------
	//  value
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The value to be rendered.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var value:Number;
}

}
