/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;

public abstract class EdgeTree {
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;
    protected double maxY;
    protected double maxX;
    protected boolean splitX;
    protected EdgeTree left;
    protected EdgeTree right;
    protected final Edge tree;

    protected EdgeTree(double minLat, double maxLat, double minLon, double maxLon, double[] lats, double[] lons) {
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.maxY = maxLat;
        this.maxX = maxLon;
        this.tree = EdgeTree.createTree(lats, lons);
    }

    public PointValues.Relation relateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        double triMinLat = StrictMath.min(StrictMath.min(ay, by), cy);
        double triMinLon = StrictMath.min(StrictMath.min(ax, bx), cx);
        if (triMinLat <= this.maxY && triMinLon <= this.maxX) {
            PointValues.Relation relation = this.internalComponentRelateTriangle(ax, ay, bx, by, cx, cy);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relateTriangle(ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            double triMaxLat = StrictMath.max(StrictMath.max(ay, by), cy);
            double triMaxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
            if (this.right != null && (!this.splitX && triMaxLat >= this.minLat || this.splitX && triMaxLon >= this.minLon) && (relation = this.right.relateTriangle(ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon) {
        if (minLat <= this.maxY && minLon <= this.maxX) {
            PointValues.Relation relation = this.internalComponentRelate(minLat, maxLat, minLon, maxLon);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxLat >= this.minLat || this.splitX && maxLon >= this.minLon) && (relation = this.right.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    protected abstract PointValues.Relation componentRelate(double var1, double var3, double var5, double var7);

    protected abstract PointValues.Relation componentRelateTriangle(double var1, double var3, double var5, double var7, double var9, double var11);

    private PointValues.Relation internalComponentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        double minLat = StrictMath.min(StrictMath.min(ay, by), cy);
        double minLon = StrictMath.min(StrictMath.min(ax, bx), cx);
        double maxLat = StrictMath.max(StrictMath.max(ay, by), cy);
        double maxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
        if (maxLon < this.minLon || minLon > this.maxLon || maxLat < this.minLat || minLat > this.maxLat) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (bx == cx && by == cy) {
            return this.componentRelateTriangle(bx, by, ax, ay, cx, cy);
        }
        return this.componentRelateTriangle(ax, ay, bx, by, cx, cy);
    }

    protected PointValues.Relation internalComponentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        if (maxLon < this.minLon || minLon > this.maxLon || maxLat < this.minLat || minLat > this.maxLat) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (minLat <= this.minLat && maxLat >= this.maxLat && minLon <= this.minLon && maxLon >= this.maxLon) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return this.componentRelate(minLat, maxLat, minLon, maxLon);
    }

    protected static EdgeTree createTree(EdgeTree[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator comparator = splitX ? (left, right) -> {
                int ret = Double.compare(left.minLon, right.minLon);
                if (ret == 0) {
                    ret = Double.compare(left.maxX, right.maxX);
                }
                return ret;
            } : (left, right) -> {
                int ret = Double.compare(left.minLat, right.minLat);
                if (ret == 0) {
                    ret = Double.compare(left.maxY, right.maxY);
                }
                return ret;
            };
            ArrayUtil.select(components, low, high + 1, mid, comparator);
        }
        EdgeTree newNode = components[mid];
        newNode.splitX = splitX;
        newNode.left = EdgeTree.createTree(components, low, mid - 1, !splitX);
        newNode.right = EdgeTree.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        return newNode;
    }

    protected static boolean pointInTriangle(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        double minX = StrictMath.min(ax, StrictMath.min(bx, cx));
        double minY = StrictMath.min(ay, StrictMath.min(by, cy));
        double maxX = StrictMath.max(ax, StrictMath.max(bx, cx));
        double maxY = StrictMath.max(ay, StrictMath.max(by, cy));
        if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            int a = GeoUtils.orient(x, y, ax, ay, bx, by);
            int b = GeoUtils.orient(x, y, bx, by, cx, cy);
            if (a == 0 || b == 0 || a < 0 == b < 0) {
                int c = GeoUtils.orient(x, y, cx, cy, ax, ay);
                return c == 0 || c < 0 == (b < 0 || a < 0);
            }
            return false;
        }
        return false;
    }

    private static Edge createTree(double[] lats, double[] lons) {
        Edge[] edges = new Edge[lats.length - 1];
        for (int i = 1; i < lats.length; ++i) {
            double lat1 = lats[i - 1];
            double lon1 = lons[i - 1];
            double lat2 = lats[i];
            double lon2 = lons[i];
            edges[i - 1] = new Edge(lat1, lon1, lat2, lon2, Math.min(lat1, lat2), Math.max(lat1, lat2));
        }
        Arrays.sort(edges, (left, right) -> {
            int ret = Double.compare(left.low, right.low);
            if (ret == 0) {
                ret = Double.compare(left.max, right.max);
            }
            return ret;
        });
        return EdgeTree.createTree(edges, 0, edges.length - 1);
    }

    private static Edge createTree(Edge[] edges, int low, int high) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        Edge newNode = edges[mid];
        newNode.left = EdgeTree.createTree(edges, low, mid - 1);
        newNode.right = EdgeTree.createTree(edges, mid + 1, high);
        if (newNode.left != null) {
            newNode.max = Math.max(newNode.max, newNode.left.max);
        }
        if (newNode.right != null) {
            newNode.max = Math.max(newNode.max, newNode.right.max);
        }
        return newNode;
    }

    static class Edge {
        final double lat1;
        final double lat2;
        final double lon1;
        final double lon2;
        final boolean dateline;
        final double low;
        double max;
        Edge left;
        Edge right;

        Edge(double lat1, double lon1, double lat2, double lon2, double low, double max) {
            this.lat1 = lat1;
            this.lon1 = lon1;
            this.lat2 = lat2;
            this.lon2 = lon2;
            this.low = low;
            this.max = max;
            this.dateline = lon1 == -180.0 && lon2 == -180.0 || lon1 == 180.0 && lon2 == 180.0;
        }

        boolean crossesTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
            double triMinLat = StrictMath.min(StrictMath.min(ay, by), cy);
            if (triMinLat <= this.max) {
                boolean outside;
                double dy = this.lat1;
                double ey = this.lat2;
                double dx = this.lon1;
                double ex = this.lon2;
                double triMinLon = StrictMath.min(StrictMath.min(ax, bx), cx);
                double triMaxLat = StrictMath.max(StrictMath.max(ay, by), cy);
                double triMaxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
                boolean bl = outside = dy < triMinLat && ey < triMinLat || dy > triMaxLat && ey > triMaxLat || dx < triMinLon && ex < triMinLon || dx > triMaxLon && ex > triMaxLon;
                if (!outside && (GeoUtils.lineCrossesLine(dx, dy, ex, ey, ax, ay, bx, by) || GeoUtils.lineCrossesLine(dx, dy, ex, ey, bx, by, cx, cy) || GeoUtils.lineCrossesLine(dx, dy, ex, ey, cx, cy, ax, ay))) {
                    return true;
                }
                if (this.left != null && this.left.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                    return true;
                }
                if (this.right != null && triMaxLat >= this.low && this.right.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                    return true;
                }
            }
            return false;
        }

        boolean crossesBox(double minLat, double maxLat, double minLon, double maxLon, boolean includeBoundary) {
            if (minLat <= this.max) {
                boolean outside;
                double cy = this.lat1;
                double dy = this.lat2;
                double cx = this.lon1;
                double dx = this.lon2;
                if (Rectangle.containsPoint(cy, cx, minLat, maxLat, minLon, maxLon) || Rectangle.containsPoint(dy, dx, minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
                boolean bl = outside = cy < minLat && dy < minLat || cy > maxLat && dy > maxLat || cx < minLon && dx < minLon || cx > maxLon && dx > maxLon;
                if (!outside) {
                    if (includeBoundary && GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, minLon, minLat, maxLon, minLat) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxLon, minLat, maxLon, maxLat) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxLon, maxLat, maxLon, minLat) || GeoUtils.lineCrossesLineWithBoundary(cx, cy, dx, dy, minLon, maxLat, minLon, minLat)) {
                        return true;
                    }
                    if (GeoUtils.lineCrossesLine(cx, cy, dx, dy, minLon, minLat, maxLon, minLat) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, maxLon, minLat, maxLon, maxLat) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, maxLon, maxLat, maxLon, minLat) || GeoUtils.lineCrossesLine(cx, cy, dx, dy, minLon, maxLat, minLon, minLat)) {
                        return true;
                    }
                }
                if (this.left != null && this.left.crossesBox(minLat, maxLat, minLon, maxLon, includeBoundary)) {
                    return true;
                }
                if (this.right != null && maxLat >= this.low && this.right.crossesBox(minLat, maxLat, minLon, maxLon, includeBoundary)) {
                    return true;
                }
            }
            return false;
        }

        boolean crossesLine(double a2x, double a2y, double b2x, double b2y) {
            double minY = StrictMath.min(a2y, b2y);
            double maxY = StrictMath.max(a2y, b2y);
            if (minY <= this.max) {
                boolean outside;
                double a1x = this.lon1;
                double a1y = this.lat1;
                double b1x = this.lon2;
                double b1y = this.lat2;
                double minX = StrictMath.min(a2x, b2x);
                double maxX = StrictMath.max(a2x, b2x);
                boolean bl = outside = a1y < minY && b1y < minY || a1y > maxY && b1y > maxY || a1x < minX && b1x < minX || a1x > maxX && b1x > maxX;
                if (!outside && GeoUtils.lineCrossesLineWithBoundary(a1x, a1y, b1x, b1y, a2x, a2y, b2x, b2y)) {
                    return true;
                }
                if (this.left != null && this.left.crossesLine(a2x, a2y, b2x, b2y)) {
                    return true;
                }
                if (this.right != null && maxY >= this.low && this.right.crossesLine(a2x, a2y, b2x, b2y)) {
                    return true;
                }
            }
            return false;
        }
    }
}

