/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.annotations.taglib.apt;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.util.ElementFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.annotations.taglib.apt.Tag;
import org.apache.struts.annotations.taglib.apt.TagAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

@SupportedAnnotationTypes(value={"org.apache.struts2.views.annotations.StrutsTag", "org.apache.struts2.views.annotations.StrutsTagAttribute", "org.apache.struts2.views.annotations.StrutsTagSkipInheritance"})
public class TagAnnotationProcessor
extends AbstractProcessor {
    public static final String TAG = "org.apache.struts2.views.annotations.StrutsTag";
    public static final String TAG_ATTRIBUTE = "org.apache.struts2.views.annotations.StrutsTagAttribute";
    public static final String TAG_SKIP_HIERARCHY = "org.apache.struts2.views.annotations.StrutsTagSkipInheritance";
    private Map<String, Tag> tags = new TreeMap<String, Tag>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String typeName;
        ExecutableElement methodDeclaration;
        this.checkOptions();
        TypeElement tagAnnotationType = this.processingEnv.getElementUtils().getTypeElement(TAG);
        TypeElement attributeAnnotationType = this.processingEnv.getElementUtils().getTypeElement(TAG_ATTRIBUTE);
        TypeElement skipAnnotationType = this.processingEnv.getElementUtils().getTypeElement(TAG_SKIP_HIERARCHY);
        Set<? extends Element> tagDeclarations = roundEnv.getElementsAnnotatedWith(tagAnnotationType);
        Set<? extends Element> attributesDeclarations = roundEnv.getElementsAnnotatedWith(attributeAnnotationType);
        Set<? extends Element> skipDeclarations = roundEnv.getElementsAnnotatedWith(skipAnnotationType);
        for (Element element : tagDeclarations) {
            Map<String, Object> values = this.getValues(element, tagAnnotationType);
            TypeElement type = (TypeElement)element;
            Tag tag = new Tag();
            tag.setDescription((String)values.get("description"));
            tag.setName((String)values.get("name"));
            tag.setTldBodyContent((String)values.get("tldBodyContent"));
            tag.setTldTagClass((String)values.get("tldTagClass"));
            tag.setDeclaredType(type.getQualifiedName().toString());
            tag.setAllowDynamicAttributes((Boolean)values.get("allowDynamicAttributes"));
            this.tags.put(type.getQualifiedName().toString(), tag);
        }
        for (Element element : skipDeclarations) {
            if (!(element instanceof ExecutableElement)) continue;
            methodDeclaration = (ExecutableElement)element;
            typeName = ((TypeElement)methodDeclaration.getEnclosingElement()).getQualifiedName().toString();
            String methodName = methodDeclaration.getSimpleName().toString();
            String name = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
            Tag tag = this.tags.get(typeName);
            if (tag == null) continue;
            this.tags.get(typeName).addSkipAttribute(name);
        }
        for (Element element : attributesDeclarations) {
            methodDeclaration = (ExecutableElement)element;
            typeName = ((TypeElement)methodDeclaration.getEnclosingElement()).getQualifiedName().toString();
            Map<String, Object> values = this.getValues(methodDeclaration, attributeAnnotationType);
            TagAttribute attribute = new TagAttribute();
            String name = (String)values.get("name");
            if (name == null || name.length() == 0) {
                String methodName = methodDeclaration.getSimpleName().toString();
                name = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
            }
            values.put("name", name);
            TagAnnotationProcessor.populateTagAttributes(attribute, values);
            Tag parentTag = this.tags.get(typeName);
            if (parentTag != null) {
                this.tags.get(typeName).addTagAttribute(attribute);
                continue;
            }
            parentTag = new Tag();
            parentTag.setDeclaredType(typeName);
            parentTag.setInclude(false);
            parentTag.addTagAttribute(attribute);
            this.tags.put(typeName, parentTag);
        }
        for (Map.Entry entry : this.tags.entrySet()) {
            this.processHierarchy((Tag)entry.getValue());
        }
        this.saveAsXml();
        this.saveTemplates();
        return true;
    }

    private static void populateTagAttributes(TagAttribute attribute, Map<String, Object> values) {
        attribute.setRequired((Boolean)values.get("required"));
        attribute.setRtexprvalue((Boolean)values.get("rtexprvalue"));
        attribute.setDefaultValue((String)values.get("defaultValue"));
        attribute.setType((String)values.get("type"));
        attribute.setDescription((String)values.get("description"));
        attribute.setName((String)values.get("name"));
    }

    private void processHierarchy(Tag tag) {
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(tag.getDeclaredType());
        List<String> skipAttributes = tag.getSkipAttributes();
        while (type != null && !(type instanceof NoType) && this.getAnnotation(type, TAG_SKIP_HIERARCHY) == null) {
            Tag parentTag = this.tags.get(type.getQualifiedName().toString());
            if (parentTag != null) {
                for (TagAttribute attribute : parentTag.getAttributes()) {
                    if (skipAttributes.contains(attribute.getName())) continue;
                    tag.addTagAttribute(attribute);
                }
            } else {
                this.addTagAttributesFromParent(tag, type);
            }
            type = (TypeElement)this.processingEnv.getTypeUtils().asElement(type.getSuperclass());
        }
    }

    private void addTagAttributesFromParent(Tag tag, TypeElement type) {
        for (ExecutableElement method : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(type))) {
            AnnotationMirror annotation = this.getAnnotation(method, TAG_ATTRIBUTE);
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC) || annotation == null) continue;
            String name = String.valueOf(Character.toLowerCase(method.getSimpleName().charAt(3))) + method.getSimpleName().subSequence(4, method.getSimpleName().length());
            if (tag.getSkipAttributes().contains(name)) continue;
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotation).entrySet()) {
                values.put(entry.getKey().getSimpleName().toString(), entry.getValue().getValue());
            }
            TagAttribute attribute = new TagAttribute();
            TagAnnotationProcessor.populateTagAttributes(attribute, values);
            attribute.setName(name);
            tag.addTagAttribute(attribute);
        }
    }

    private AnnotationMirror getAnnotation(Element element, String annotationName) {
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement(annotationName);
        if (element != null && element.getAnnotationMirrors() != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().equals(annotation)) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private void checkOptions() {
        if (this.getOption("tlibVersion") == null) {
            throw new IllegalArgumentException("'tlibVersion' is missing");
        }
        if (this.getOption("jspVersion") == null) {
            throw new IllegalArgumentException("'jspVersion' is missing");
        }
        if (this.getOption("shortName") == null) {
            throw new IllegalArgumentException("'shortName' is missing");
        }
        if (this.getOption("description") == null) {
            throw new IllegalArgumentException("'description' is missing");
        }
        if (this.getOption("displayName") == null) {
            throw new IllegalArgumentException("'displayName' is missing");
        }
        if (this.getOption("uri") == null) {
            throw new IllegalArgumentException("'uri' is missing");
        }
        if (this.getOption("outTemplatesDir") == null) {
            throw new IllegalArgumentException("'outTemplatesDir' is missing");
        }
        if (this.getOption("outFile") == null) {
            throw new IllegalArgumentException("'outFile' is missing");
        }
    }

    private void saveTemplates() {
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(this.getClass(), "");
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        try {
            Template template = config.getTemplate("tag.ftl");
            String rootDir = new File(this.getOption("outTemplatesDir")).getAbsolutePath();
            for (Tag tag : this.tags.values()) {
                if (!tag.isInclude()) continue;
                HashMap<String, Tag> root = new HashMap<String, Tag>();
                root.put("tag", tag);
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(rootDir, tag.getName() + ".html")));
                Throwable throwable = null;
                try {
                    template.process(root, (Writer)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveAsXml() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            org.w3c.dom.Element tagLib = document.createElement("taglib");
            tagLib.setAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
            tagLib.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            tagLib.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd");
            tagLib.setAttribute("version", this.getOption("jspVersion"));
            document.appendChild(tagLib);
            TagAnnotationProcessor.appendTextNode(document, tagLib, "description", this.getOption("description"), true);
            TagAnnotationProcessor.appendTextNode(document, tagLib, "display-name", this.getOption("displayName"), false);
            TagAnnotationProcessor.appendTextNode(document, tagLib, "tlib-version", this.getOption("tlibVersion"), false);
            TagAnnotationProcessor.appendTextNode(document, tagLib, "short-name", this.getOption("shortName"), false);
            TagAnnotationProcessor.appendTextNode(document, tagLib, "uri", this.getOption("uri"), false);
            for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
                Tag tag = entry.getValue();
                if (!tag.isInclude()) continue;
                TagAnnotationProcessor.createElement(document, tagLib, tag);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 2);
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            File outputFile = new File(this.getOption("outFile"));
            File parentDir = outputFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new OutputStreamWriter(new FileOutputStream(outputFile)));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getOption(String name) {
        if (this.processingEnv.getOptions().containsKey(name)) {
            return this.processingEnv.getOptions().get(name);
        }
        for (Map.Entry<String, String> entry : this.processingEnv.getOptions().entrySet()) {
            String key = entry.getKey();
            String[] splitted = key.split("=");
            if (!splitted[0].equals("-A" + name)) continue;
            return splitted[1];
        }
        return null;
    }

    private static void createElement(Document doc, org.w3c.dom.Element tagLibElement, Tag tag) {
        org.w3c.dom.Element tagElement = doc.createElement("tag");
        tagLibElement.appendChild(tagElement);
        TagAnnotationProcessor.appendTextNode(doc, tagElement, "description", tag.getDescription(), true);
        TagAnnotationProcessor.appendTextNode(doc, tagElement, "name", tag.getName(), false);
        TagAnnotationProcessor.appendTextNode(doc, tagElement, "tag-class", tag.getTldTagClass(), false);
        TagAnnotationProcessor.appendTextNode(doc, tagElement, "body-content", tag.getTldBodyContent(), false);
        for (TagAttribute attribute : tag.getAttributes()) {
            TagAnnotationProcessor.createElement(doc, tagElement, attribute);
        }
        TagAnnotationProcessor.appendTextNode(doc, tagElement, "dynamic-attributes", String.valueOf(tag.isAllowDynamicAttributes()), false);
    }

    private static void createElement(Document doc, org.w3c.dom.Element tagElement, TagAttribute attribute) {
        org.w3c.dom.Element attributeElement = doc.createElement("attribute");
        tagElement.appendChild(attributeElement);
        TagAnnotationProcessor.appendTextNode(doc, attributeElement, "description", attribute.getDescription(), true);
        TagAnnotationProcessor.appendTextNode(doc, attributeElement, "name", attribute.getName(), false);
        TagAnnotationProcessor.appendTextNode(doc, attributeElement, "required", String.valueOf(attribute.isRequired()), false);
        TagAnnotationProcessor.appendTextNode(doc, attributeElement, "rtexprvalue", String.valueOf(attribute.isRtexprvalue()), false);
    }

    private static void appendTextNode(Document doc, org.w3c.dom.Element element, String name, String text, boolean cdata) {
        Text textNode = cdata ? doc.createCDATASection(text) : doc.createTextNode(text);
        org.w3c.dom.Element newElement = doc.createElement(name);
        newElement.appendChild(textNode);
        element.appendChild(newElement);
    }

    private Map<String, Object> getValues(Element element, TypeElement type) {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().asElement().equals(type)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elementEntry : this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
                values.put(elementEntry.getKey().getSimpleName().toString(), elementEntry.getValue().getValue());
            }
        }
        return values;
    }
}

