/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private String defaultNamespaceURI;
    private Map<String, String> prefixesToNamespaces;
    int prefixCounter;
    private Node dom;

    public NamespaceResolver() {
    }

    public NamespaceResolver(NamespaceResolver namespaceResolver) {
        this.defaultNamespaceURI = namespaceResolver.defaultNamespaceURI;
        Map<String, String> namespaceResolverPrefixesToNamespaces = namespaceResolver.prefixesToNamespaces;
        if (namespaceResolverPrefixesToNamespaces != null) {
            this.prefixesToNamespaces = new LinkedHashMap<String, String>(namespaceResolverPrefixesToNamespaces.size());
            this.prefixesToNamespaces.putAll(namespaceResolver.prefixesToNamespaces);
        }
        this.prefixCounter = namespaceResolver.prefixCounter;
        this.dom = namespaceResolver.dom;
    }

    public Map<String, String> getPrefixesToNamespaces() {
        if (this.prefixesToNamespaces == null) {
            this.prefixesToNamespaces = new LinkedHashMap<String, String>();
        }
        return this.prefixesToNamespaces;
    }

    public boolean hasPrefixesToNamespaces() {
        return this.prefixesToNamespaces != null;
    }

    public boolean hasPrefix(String prefix) {
        return this.prefixesToNamespaces != null ? this.prefixesToNamespaces.containsKey(prefix) : false;
    }

    public void setDOM(Node dom) {
        this.dom = dom;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultNamespaceURI;
        }
        String uri = null;
        if (this.prefixesToNamespaces != null) {
            uri = this.prefixesToNamespaces.get(prefix);
        }
        if (uri != null) {
            return uri;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.dom != null) {
            return XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(this.dom, prefix);
        }
        return null;
    }

    public String resolveNamespaceURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (this.prefixesToNamespaces != null) {
            for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
                if (!uri.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, uri);
    }

    private String resolveNamespaceURI(Node node, String uri) {
        if (node == null) {
            return null;
        }
        if (uri.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int namedNodeMapSize = namedNodeMap.getLength();
            int x = 0;
            while (x < namedNodeMapSize) {
                Node attr = namedNodeMap.item(x);
                if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && uri.equals(attr.getNodeValue())) {
                    if (attr.getLocalName() != null && !attr.getLocalName().equals("xmlns")) {
                        return attr.getLocalName();
                    }
                    return "";
                }
                ++x;
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), uri);
    }

    public void put(String prefix, String namespaceURI) {
        if (prefix == null || prefix.length() == 0) {
            this.defaultNamespaceURI = namespaceURI;
        } else {
            LinkedHashMap<String, String> removedItems = null;
            if (this.getPrefixesToNamespaces().containsValue(namespaceURI.intern())) {
                removedItems = new LinkedHashMap<String, String>();
                for (Map.Entry entry : this.getPrefixesToNamespaces().entrySet()) {
                    if (!namespaceURI.intern().equals(entry.getValue())) continue;
                    removedItems.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (removedItems != null) {
                for (String string : removedItems.keySet()) {
                    this.getPrefixesToNamespaces().remove(string);
                }
            }
            this.getPrefixesToNamespaces().put(prefix, namespaceURI.intern());
            if (removedItems != null) {
                for (Map.Entry entry : removedItems.entrySet()) {
                    this.getPrefixesToNamespaces().put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    public Enumeration getPrefixes() {
        if (this.hasPrefixesToNamespaces()) {
            return new IteratorEnumeration(this.getPrefixesToNamespaces().keySet().iterator());
        }
        return new IteratorEnumeration(null);
    }

    public Vector getNamespaces() {
        if (!this.hasPrefixesToNamespaces()) {
            return new Vector(0);
        }
        Vector<Namespace> names = new Vector<Namespace>(this.prefixesToNamespaces.size());
        for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
            Namespace namespace = new Namespace(entry.getKey(), entry.getValue());
            names.addElement(namespace);
        }
        return names;
    }

    public void setNamespaces(Vector names) {
        this.prefixesToNamespaces = new LinkedHashMap<String, String>(names.size());
        for (Namespace namespace : names) {
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            this.prefixesToNamespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public String generatePrefix() {
        return this.generatePrefix(this.getNextPrefix());
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String defaultPrefix) {
        String lookup = this.resolveNamespacePrefix(defaultPrefix);
        while (lookup != null) {
            defaultPrefix = this.getNextPrefix();
            lookup = this.resolveNamespacePrefix(defaultPrefix);
        }
        return defaultPrefix;
    }

    public void removeNamespace(String prefix) {
        if (this.prefixesToNamespaces != null) {
            this.prefixesToNamespaces.remove(prefix);
        }
    }

    public void setDefaultNamespaceURI(String namespaceUri) {
        this.defaultNamespaceURI = namespaceUri == null ? null : namespaceUri.intern();
    }

    public String getDefaultNamespaceURI() {
        if (this.defaultNamespaceURI != null) {
            return this.defaultNamespaceURI;
        }
        if (this.dom != null) {
            return XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(this.dom, null);
        }
        return null;
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

