/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.blogclient.metaweblog;

import com.rometools.propono.blogclient.Blog;
import com.rometools.propono.blogclient.BlogClientException;
import com.rometools.propono.blogclient.BlogEntry;
import com.rometools.propono.blogclient.BlogResource;
import com.rometools.propono.blogclient.metaweblog.MetaWeblogEntry;
import com.rometools.propono.blogclient.metaweblog.MetaWeblogResource;
import com.rometools.propono.blogclient.metaweblog.NoOpIterator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

@Deprecated
public class MetaWeblogBlog
implements Blog {
    private final String blogid;
    private final String name;
    private final URL url;
    private final String userName;
    private final String password;
    private final Map<String, MetaWeblogBlogCollection> collections;
    private String appkey = "dummy";
    private XmlRpcClient xmlRpcClient = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getToken() {
        return this.blogid;
    }

    public String toString() {
        return this.getName();
    }

    private XmlRpcClient getXmlRpcClient() {
        if (this.xmlRpcClient == null) {
            XmlRpcClientConfigImpl xmlrpcConfig = new XmlRpcClientConfigImpl();
            xmlrpcConfig.setServerURL(this.url);
            this.xmlRpcClient = new XmlRpcClient();
            this.xmlRpcClient.setConfig((XmlRpcClientConfig)xmlrpcConfig);
        }
        return this.xmlRpcClient;
    }

    MetaWeblogBlog(String blogid, String name, URL url, String userName, String password) {
        this.blogid = blogid;
        this.name = name;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.collections = new TreeMap<String, MetaWeblogBlogCollection>();
        this.collections.put("entries", new MetaWeblogBlogCollection(this, "entries", "Entries", "entry"));
        this.collections.put("resources", new MetaWeblogBlogCollection(this, "resources", "Resources", "*"));
    }

    MetaWeblogBlog(String blogId, String name, URL url, String userName, String password, String appkey) {
        this(blogId, name, url, userName, password);
        this.appkey = appkey;
    }

    @Override
    public BlogEntry newEntry() {
        return new MetaWeblogEntry(this, new HashMap<String, Object>());
    }

    String saveEntry(BlogEntry entry) throws BlogClientException {
        Blog.Collection col = this.collections.get("entries");
        return col.saveEntry(entry);
    }

    @Override
    public BlogEntry getEntry(String id) throws BlogClientException {
        try {
            Object[] params = new Object[]{id, this.userName, this.password};
            Object response = this.getXmlRpcClient().execute("metaWeblog.getPost", params);
            Map result = (Map)response;
            return new MetaWeblogEntry(this, result);
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
        }
    }

    void deleteEntry(String id) throws BlogClientException {
        try {
            this.getXmlRpcClient().execute("blogger.deletePost", new Object[]{this.appkey, id, this.userName, this.password, Boolean.FALSE});
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
        }
    }

    @Override
    public Iterator<BlogEntry> getEntries() throws BlogClientException {
        return new EntryIterator();
    }

    @Override
    public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
        return new MetaWeblogResource(this, name, contentType, bytes);
    }

    String saveResource(MetaWeblogResource resource) throws BlogClientException {
        Blog.Collection col = this.collections.get("resources");
        return col.saveResource(resource);
    }

    BlogResource getResource(String token) throws BlogClientException {
        return null;
    }

    public NoOpIterator<BlogEntry> getResources() throws BlogClientException {
        return new NoOpIterator<BlogEntry>();
    }

    void deleteResource(BlogResource resource) throws BlogClientException {
    }

    @Override
    public List<BlogEntry.Category> getCategories() throws BlogClientException {
        ArrayList<BlogEntry.Category> ret = new ArrayList<BlogEntry.Category>();
        try {
            Object result = this.getXmlRpcClient().execute("metaWeblog.getCategories", new Object[]{this.blogid, this.userName, this.password});
            if (result != null && result instanceof HashMap) {
                Map catsmap = (Map)result;
                Set keys = catsmap.keySet();
                for (String key : keys) {
                    Map catmap = (Map)catsmap.get(key);
                    BlogEntry.Category category = new BlogEntry.Category(key);
                    String description = (String)catmap.get("description");
                    category.setName(description);
                    ret.add(category);
                }
            } else if (result != null && result instanceof Object[]) {
                Object[] array;
                for (Object map : array = (Object[])result) {
                    Map catmap = (Map)map;
                    String categoryId = (String)catmap.get("categoryId");
                    String categoryName = (String)catmap.get("categoryName");
                    BlogEntry.Category category = new BlogEntry.Category(categoryId);
                    category.setName(categoryName);
                    ret.add(category);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private Map<String, Object> createPostStructure(BlogEntry entry) {
        return ((MetaWeblogEntry)entry).toPostStructure();
    }

    @Override
    public List<Blog.Collection> getCollections() throws BlogClientException {
        return new ArrayList<Blog.Collection>(this.collections.values());
    }

    @Override
    public Blog.Collection getCollection(String token) throws BlogClientException {
        return this.collections.get(token);
    }

    public class EntryIterator
    implements Iterator<BlogEntry> {
        private int pos = 0;
        private boolean eod = false;
        private static final int BUFSIZE = 30;
        private List<Map<String, Object>> results = null;

        public EntryIterator() throws BlogClientException {
            this.getNextEntries();
        }

        @Override
        public boolean hasNext() {
            if (this.pos == this.results.size() && !this.eod) {
                try {
                    this.getNextEntries();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.pos < this.results.size();
        }

        @Override
        public BlogEntry next() {
            return new MetaWeblogEntry(MetaWeblogBlog.this, this.results.get(this.pos++));
        }

        @Override
        public void remove() {
        }

        private void getNextEntries() throws BlogClientException {
            int requestSize = this.pos + 30;
            try {
                Object[] params = new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, new Integer(requestSize)};
                Object response = MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.getRecentPosts", params);
                Map[] resultsArray = (Map[])response;
                this.results = Arrays.asList(resultsArray);
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
            }
            if (this.results.size() < requestSize) {
                this.eod = true;
            }
        }
    }

    public class MetaWeblogBlogCollection
    implements Blog.Collection {
        private String accept = null;
        private String title = null;
        private String token = null;
        private Blog blog = null;

        public MetaWeblogBlogCollection(Blog blog, String token, String title, String accept) {
            this.blog = blog;
            this.accept = accept;
            this.title = title;
            this.token = token;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public List<String> getAccepts() {
            return Collections.singletonList(this.accept);
        }

        @Override
        public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
            return this.blog.newResource(name, contentType, bytes);
        }

        @Override
        public BlogEntry newEntry() throws BlogClientException {
            return this.blog.newEntry();
        }

        @Override
        public boolean accepts(String ct) {
            if (this.accept.equals("*")) {
                return true;
            }
            return this.accept.equals("entry") && ct.equals("application/metaweblog+xml");
        }

        @Override
        public Iterator<BlogEntry> getEntries() throws BlogClientException {
            Iterator ret = null;
            ret = this.accept.equals("entry") ? MetaWeblogBlog.this.getEntries() : MetaWeblogBlog.this.getResources();
            return ret;
        }

        @Override
        public String saveEntry(BlogEntry entry) throws BlogClientException {
            String ret = entry.getId();
            if (entry.getId() == null) {
                try {
                    ret = (String)MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.newPost", new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, MetaWeblogBlog.this.createPostStructure(entry), new Boolean(!entry.getDraft())});
                }
                catch (Exception e) {
                    throw new BlogClientException("ERROR: XML-RPC error saving new entry", e);
                }
            }
            try {
                MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.editPost", new Object[]{entry.getId(), MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, MetaWeblogBlog.this.createPostStructure(entry), new Boolean(!entry.getDraft())});
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: XML-RPC error updating entry", e);
            }
            return ret;
        }

        @Override
        public String saveResource(BlogResource res) throws BlogClientException {
            MetaWeblogResource resource = (MetaWeblogResource)res;
            try {
                HashMap<String, Object> resmap = new HashMap<String, Object>();
                resmap.put("name", resource.getName());
                resmap.put("type", resource.getContent().getType());
                resmap.put("bits", resource.getBytes());
                Object[] params = new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, resmap};
                Object response = MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.newMediaObject", params);
                Map result = (Map)response;
                String url = (String)result.get("url");
                res.getContent().setSrc(url);
                return url;
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: loading or uploading file", e);
            }
        }

        @Override
        public List<BlogEntry.Category> getCategories() throws BlogClientException {
            return MetaWeblogBlog.this.getCategories();
        }

        @Override
        public Blog getBlog() {
            return this.blog;
        }
    }
}

