/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.server;

import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.atom.common.Categories;
import com.rometools.propono.atom.server.AtomException;
import com.rometools.propono.atom.server.AtomHandler;
import com.rometools.propono.atom.server.AtomHandlerFactory;
import com.rometools.propono.atom.server.AtomMediaResource;
import com.rometools.propono.atom.server.AtomRequestImpl;
import com.rometools.propono.utils.Utilities;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.atom.Content;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.io.WireFeedOutput;
import com.rometools.rome.io.impl.Atom10Generator;
import com.rometools.rome.io.impl.Atom10Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AtomServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String FEED_TYPE = "atom_1.0";
    private static String contextDirPath = null;
    private static final Logger LOG = LoggerFactory.getLogger(AtomServlet.class);

    private AtomHandler createAtomRequestHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        AtomHandlerFactory ahf = AtomHandlerFactory.newInstance();
        return ahf.newAtomHandler(request, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block12: {
            LOG.debug("Entering");
            AtomHandler handler = this.createAtomRequestHandler(req, res);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                AtomRequestImpl areq = new AtomRequestImpl(req);
                try {
                    if (handler.isAtomServiceURI(areq)) {
                        AtomService service = handler.getAtomService(areq);
                        Document doc = service.serviceToDocument();
                        res.setContentType("application/atomsvc+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.setFormat(Format.getPrettyFormat());
                        outputter.output(doc, (Writer)writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block12;
                    }
                    if (handler.isCategoriesURI(areq)) {
                        Categories cats = handler.getCategories(areq);
                        res.setContentType("application/xml");
                        PrintWriter writer = res.getWriter();
                        Document catsDoc = new Document();
                        catsDoc.setRootElement(cats.categoriesToElement());
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.output(catsDoc, (Writer)writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block12;
                    }
                    if (handler.isCollectionURI(areq)) {
                        Feed col = handler.getCollection(areq);
                        col.setFeedType(FEED_TYPE);
                        WireFeedOutput wireFeedOutput = new WireFeedOutput();
                        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)col);
                        res.setContentType("application/atom+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.setFormat(Format.getPrettyFormat());
                        outputter.output(feedDoc, (Writer)writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block12;
                    }
                    if (handler.isEntryURI(areq)) {
                        Entry entry = handler.getEntry(areq);
                        if (entry != null) {
                            res.setContentType("application/atom+xml; type=entry; charset=utf-8");
                            PrintWriter writer = res.getWriter();
                            Atom10Generator.serializeEntry((Entry)entry, (Writer)writer);
                            ((Writer)writer).close();
                        } else {
                            res.setStatus(404);
                        }
                        break block12;
                    }
                    if (handler.isMediaEditURI(areq)) {
                        AtomMediaResource entry = handler.getMediaResource(areq);
                        res.setContentType(entry.getContentType());
                        res.setContentLength((int)entry.getContentLength());
                        Utilities.copyInputToOutput(entry.getInputStream(), (OutputStream)res.getOutputStream());
                        res.getOutputStream().flush();
                        res.getOutputStream().close();
                        break block12;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                    LOG.debug("An error occured while processing GET", (Throwable)ae);
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    LOG.debug("An error occured while processing GET", (Throwable)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"AtomPub\"");
                res.sendError(401);
            }
        }
        LOG.debug("Exiting");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block14: {
            LOG.debug("Entering");
            AtomHandler handler = this.createAtomRequestHandler(req, res);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                AtomRequestImpl areq = new AtomRequestImpl(req);
                try {
                    if (handler.isCollectionURI(areq)) {
                        if (req.getContentType().startsWith("application/atom+xml")) {
                            Link link;
                            Entry entry = Atom10Parser.parseEntry((Reader)new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8")), null, (Locale)Locale.US);
                            Entry newEntry = handler.postEntry(areq, entry);
                            for (Object element : newEntry.getOtherLinks()) {
                                link = (Link)element;
                                if (!"edit".equals(link.getRel())) continue;
                                res.addHeader("Location", link.getHrefResolved());
                                break;
                            }
                            for (Object element : newEntry.getAlternateLinks()) {
                                link = (Link)element;
                                if (!"alternate".equals(link.getRel())) continue;
                                res.addHeader("Content-Location", link.getHrefResolved());
                                break;
                            }
                            res.setStatus(201);
                            res.setContentType("application/atom+xml; type=entry; charset=utf-8");
                            PrintWriter writer = res.getWriter();
                            Atom10Generator.serializeEntry((Entry)newEntry, (Writer)writer);
                            ((Writer)writer).close();
                        } else if (req.getContentType() != null) {
                            Link link;
                            String title = areq.getHeader("Title");
                            Entry resource = new Entry();
                            resource.setTitle(title);
                            Content content = new Content();
                            content.setType(areq.getContentType());
                            resource.setContents(Collections.singletonList(content));
                            Entry newEntry = handler.postMedia(areq, resource);
                            for (Object element : newEntry.getOtherLinks()) {
                                link = (Link)element;
                                if (!"edit".equals(link.getRel())) continue;
                                res.addHeader("Location", link.getHrefResolved());
                                break;
                            }
                            for (Object element : newEntry.getAlternateLinks()) {
                                link = (Link)element;
                                if (!"alternate".equals(link.getRel())) continue;
                                res.addHeader("Content-Location", link.getHrefResolved());
                                break;
                            }
                            res.setStatus(201);
                            res.setContentType("application/atom+xml; type=entry; charset=utf-8");
                            PrintWriter writer = res.getWriter();
                            Atom10Generator.serializeEntry((Entry)newEntry, (Writer)writer);
                            ((Writer)writer).close();
                        } else {
                            res.sendError(415, "No content-type specified in request");
                        }
                        break block14;
                    }
                    res.sendError(404, "Invalid collection specified in request");
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                    LOG.debug("An error occured while processing POST", (Throwable)ae);
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    LOG.debug("An error occured while processing POST", (Throwable)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"AtomPub\"");
                res.sendError(401);
            }
        }
        LOG.debug("Exiting");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            LOG.debug("Entering");
            AtomHandler handler = this.createAtomRequestHandler(req, res);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                AtomRequestImpl areq = new AtomRequestImpl(req);
                try {
                    if (handler.isEntryURI(areq)) {
                        Entry unsavedEntry = Atom10Parser.parseEntry((Reader)new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8")), null, (Locale)Locale.US);
                        handler.putEntry(areq, unsavedEntry);
                        res.setStatus(200);
                        break block7;
                    }
                    if (handler.isMediaEditURI(areq)) {
                        handler.putMedia(areq);
                        res.setStatus(200);
                        break block7;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                    LOG.debug("An error occured while processing PUT", (Throwable)ae);
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    LOG.debug("An error occured while processing PUT", (Throwable)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"AtomPub\"");
                res.setStatus(401);
            }
        }
        LOG.debug("Exiting");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            LOG.debug("Entering");
            AtomHandler handler = this.createAtomRequestHandler(req, res);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                AtomRequestImpl areq = new AtomRequestImpl(req);
                try {
                    if (handler.isEntryURI(areq)) {
                        handler.deleteEntry(areq);
                        res.setStatus(200);
                        break block6;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                    LOG.debug("An error occured while processing DELETE", (Throwable)ae);
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    LOG.debug("An error occured while processing DELETE", (Throwable)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"AtomPub\"");
                res.setStatus(401);
            }
        }
        LOG.debug("Exiting");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        contextDirPath = this.getServletContext().getRealPath("/");
    }

    public static String getContextDirPath() {
        return contextDirPath;
    }

    static {
        Atom10Parser.setResolveURIs((boolean)true);
    }
}

