/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ax.AxMessage;

public abstract class AxPayload
extends AxMessage {
    private static Log _log = LogFactory.getLog(AxPayload.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private int _attrAliasCounter = 0;

    private synchronized String generateAlias() {
        return "attr" + Integer.toString(++this._attrAliasCounter);
    }

    public void addAttribute(String alias, String typeUri, String value) throws MessageException {
        if (alias.indexOf(44) > -1 || alias.indexOf(46) > -1 || alias.indexOf(58) > -1 || alias.indexOf(10) > -1) {
            throw new MessageException("Characters [.,:\\n] are not allowed in attribute aliases: " + alias);
        }
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this._parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this._parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this._parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this._parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to AX payload; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public String addAttribute(String typeUri, String value) {
        String alias = this.generateAlias();
        this._parameters.set(new Parameter("type." + alias, typeUri));
        this._parameters.set(new Parameter("value." + alias, value));
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to the AX payload; type: " + typeUri + " alias: " + alias));
        }
        return alias;
    }

    public void addAttributes(Map attributes) {
        for (String typeUri : attributes.keySet()) {
            this.addAttribute(typeUri, (String)attributes.get(typeUri));
        }
    }

    public List getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this._parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            for (int i = 1; i <= this.getCount(alias); ++i) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
            }
        }
        return values;
    }

    public String getAttributeTypeUri(String alias) {
        return this._parameters.getParameterValue("type." + alias);
    }

    public String getAttributeAlias(String typeUri) {
        if (typeUri == null) {
            return null;
        }
        for (Parameter param : this._parameters.getParameters()) {
            if (!param.getKey().startsWith("type.") || !typeUri.equals(param.getValue())) continue;
            return param.getKey().substring(5);
        }
        return null;
    }

    public String getAttributeValueByTypeUri(String typeUri) {
        return this.getAttributeValue(this.getAttributeAlias(typeUri));
    }

    public List getAttributeValuesByTypeUri(String typeUri) {
        return this.getAttributeValues(this.getAttributeAlias(typeUri));
    }

    public String getAttributeValue(String alias) {
        return this._parameters.hasParameter("count." + alias) && this.getCount(alias) > 0 ? this.getParameterValue("value." + alias + ".1") : this.getParameterValue("value." + alias);
    }

    public List getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("type.") || aliases.contains(alias = paramName.substring(5))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map getAttributes() {
        HashMap<String, List> attributes = new HashMap<String, List>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("type.") || attributes.containsKey(alias = paramName.substring(5))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public Map getAttributeTypes() {
        HashMap<String, String> typeUris = new HashMap<String, String>();
        for (Parameter param : this._parameters.getParameters()) {
            String alias;
            String paramName = param.getKey();
            String paramType = param.getValue();
            if (!paramName.startsWith("type.") || typeUris.containsKey(alias = paramName.substring(5))) continue;
            typeUris.put(alias, paramType);
        }
        return typeUris;
    }

    public int getCount(String alias) {
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        if (this._parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    protected boolean isValid() {
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("count.") || paramName.startsWith("value.") || paramName.equals("update_url")) continue;
            _log.warn((Object)("Invalid parameter name in AX payload: " + paramName));
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        List aliases = this.getAttributeAliases();
        for (String alias : aliases) {
            if (!this._parameters.hasParameter("type." + alias)) {
                _log.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this._parameters.hasParameter("count." + alias)) {
                if (!this._parameters.hasParameterPrefix("value." + alias + ".")) continue;
                _log.warn((Object)("Count parameter not present for alias: " + alias + "; value." + alias + ".[index] format is not allowed."));
                return false;
            }
            if (this._parameters.hasParameter("value." + alias)) {
                _log.warn((Object)("Count parameter present for alias: " + alias + "; should use value." + alias + ".[index] format."));
                return false;
            }
            int count = this.getCount(alias);
            if (count < 0) {
                _log.warn((Object)("Invalid value for count." + alias + ": " + count));
                return false;
            }
            for (int i = 1; i <= count; ++i) {
                if (this._parameters.hasParameter("value." + alias + "." + Integer.toString(i))) continue;
                _log.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                return false;
            }
        }
        return true;
    }
}

