/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.river.fiddler;

import net.jini.config.ConfigurationException;

import javax.security.auth.login.LoginException;

import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.MarshalledObject;
import java.io.IOException;

/**
 * Convenience class intended for use with the 
 * {@link org.apache.river.start.ServiceStarter} framework to start
 * an implementation of Fiddler that is activatable, and which will
 * log its state information to persistent storage.
 *
 * @author Sun Microsystems, Inc.
 * @since 2.0
 */
class ActivatableFiddlerImpl extends FiddlerImpl {

    /**
     * Constructs a new instance of <code>FiddlerImpl</code> that is 
     * activatable, and which will persist its state.
     * <p>
     * A constructor having this signature is required for the class to
     * be activatable. This constructor is automatically called by the 
     * activation group when the service is activated.
     *
     * @param activationID the activation ID generated by the activation
     *                     system and assigned to the instance of the server
     *                     being activated
     * @param data         state data (represented as a 
     *                     <code>MarshalledObject</code>) which is needed to
     *                     re-activate this server
     *
     * @throws IOException            this exception can occur when there is
     *                                a problem recovering data from disk,
     *                                exporting the server that's being
     *                                activated, or when unmarshalling the
     *                                given <code>data</code> parameter.
     * @throws ConfigurationException this exception can occur when a
     *                                problem occurs while retrieving an item
     *                                from the <code>Configuration</code>
     *                                generated from the contents of the
     *                                given <code>data</code> parameter
     * @throws ActivationException    this exception can occur when a problem
     *                                occurs while activating the service
     * @throws LoginException         this exception occurs when authentication
     *                                fails while performing a JAAS login for
     *                                this service
     * @throws ClassNotFoundException this exception can occur while 
     *                                unmarshalling the given <code>data</code>
     *                                parameter; when a class needed in the
     *                                unmarshalling process cannot be found.
     * @throws ClassCastException     this exception can occur while
     *                                unmarshalling the given <code>data</code>
     *                                parameter; when the contents of that
     *                                parameter is not a <code>String</code>
     *                                array.
     */
    ActivatableFiddlerImpl(ActivationID activationID,
                           MarshalledObject data)
                                               throws IOException,
                                                      ActivationException,
                                                      ConfigurationException,
                                                      LoginException,
                                                      ClassNotFoundException
    {
        super(activationID, data);
    }//end constructor

}//end class ActivatableFiddlerImpl

