/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.river.qa.harness;

import org.apache.river.start.ServiceDescriptor;
import java.io.Serializable;

/**
 * Mutates a <code>ServiceDescriptor</code>. Implementations of
 * this interface are to be used by tests which must manipulate
 * the contents of a <code>ServiceDescriptor</code> after it
 * has been generated by a service admin, but before it's 
 * <code>create</code> method is called.
 */
public interface ServiceDescriptorTransformer extends Serializable {

    /**
     * Mutate the <code>ServiceDescriptor</code>. The returned object
     * must be of the same type as the argument passed to this
     * method.
     *
     * @param descriptor the descriptor to transorm
     * @return the transformed object
     */
    public ServiceDescriptor transform(ServiceDescriptor descriptor);
}
