
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/* @test 
 * @summary Verify proper functioning of checks against invalid permission
 * 	    classes specified in GrantPermission name
 */

import java.security.Security;
import net.jini.security.GrantPermission;

public class Test {
    public static void main(String[] args) {
	Security.setProperty(
	    "package.access", "sun.,net.jini.security.policy.");
	System.setSecurityManager(new SecurityManager());
	try {
	    new GrantPermission(
		"net.jini.security.policy.UmbrellaGrantPermission");
	    throw new Error();
	} catch (SecurityException e) {
	    System.out.println("caught expected exception: " + e);
	}
	try {
	    new GrantPermission("java.lang.Object");
	    throw new Error();
	} catch (IllegalArgumentException e) {
	    System.out.println("caught expected exception: " + e);
	}
    }
}
