/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.bonecp;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.plugin.JDBCConnectionProviderFactory;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.bonecp.BoneCPConnectionProvider;

@PluggableService
public class BoneCPConnectionProviderFactory
implements JDBCConnectionProviderFactory {
    public static final String PARTITION_COUNT = "qpid.jdbcstore.bonecp.partitionCount";
    public static final String MAX_CONNECTIONS_PER_PARTITION = "qpid.jdbcstore.bonecp.maxConnectionsPerPartition";
    public static final String MIN_CONNECTIONS_PER_PARTITION = "qpid.jdbcstore.bonecp.minConnectionsPerPartition";
    private final Set<String> _supportedAttributes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("qpid.jdbcstore.bonecp.partitionCount", "qpid.jdbcstore.bonecp.maxConnectionsPerPartition", "qpid.jdbcstore.bonecp.minConnectionsPerPartition")));

    public String getType() {
        return "BONECP";
    }

    public ConnectionProvider getConnectionProvider(String connectionUrl, String username, String password, Map<String, String> providerAttributes) throws SQLException {
        return new BoneCPConnectionProvider(connectionUrl, username, password, providerAttributes);
    }

    public Set<String> getProviderAttributeNames() {
        return this._supportedAttributes;
    }
}

