/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;
import org.apache.qpid.server.virtualhost.berkeleydb.BDBHAReplicaVirtualHost;

@ManagedObject(category=false, type="BDB_HA_REPLICA", register=false)
public class BDBHAReplicaVirtualHostImpl
extends AbstractConfiguredObject<BDBHAReplicaVirtualHostImpl>
implements BDBHAReplicaVirtualHost<BDBHAReplicaVirtualHostImpl> {
    private final Broker<?> _broker;
    private final VirtualHostPrincipal _principal;
    @ManagedAttributeField
    private boolean _queue_deadLetterQueueEnabled;
    @ManagedAttributeField
    private long _housekeepingCheckPeriod;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutWarn;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutWarn;
    @ManagedAttributeField
    private int _housekeepingThreadCount;
    @ManagedAttributeField
    private int _connectionThreadPoolSize;
    @ManagedAttributeField
    private int _numberOfSelectors;
    @ManagedAttributeField
    private List<String> _enabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _disabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _globalAddressDomains;
    @ManagedAttributeField
    private List<NodeAutoCreationPolicy> _nodeAutoCreationPolicies;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true, condition="org.apache.qpid.server.JECheck#isAvailable()")
    public BDBHAReplicaVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(BDBHAReplicaVirtualHostImpl.parentsMap((ConfiguredObject[])new ConfiguredObject[]{virtualHostNode}), attributes);
        this._broker = (Broker)virtualHostNode.getParent(Broker.class);
        this._principal = new VirtualHostPrincipal((VirtualHost)this);
        this.setState(State.UNAVAILABLE);
    }

    public boolean isActive() {
        return false;
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        this.throwUnsupportedForReplica();
    }

    public String getModelVersion() {
        return "6.1";
    }

    public void executeTask(String name, Runnable task, AccessControlContext context) {
        this.throwUnsupportedForReplica();
    }

    public Broker<?> getBroker() {
        return this._broker;
    }

    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        this.throwUnsupportedForReplica();
        return null;
    }

    public MessageDestination getAttainedMessageDestination(String name) {
        return null;
    }

    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> childClass, String address) {
        return null;
    }

    public void executeTransaction(VirtualHost.TransactionalOperation op) {
        this.throwUnsupportedForReplica();
    }

    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    public boolean isQueue_deadLetterQueueEnabled() {
        return false;
    }

    public long getHousekeepingCheckPeriod() {
        return 0L;
    }

    public long getStoreTransactionIdleTimeoutClose() {
        return 0L;
    }

    public long getStoreTransactionIdleTimeoutWarn() {
        return 0L;
    }

    public long getStoreTransactionOpenTimeoutClose() {
        return 0L;
    }

    public long getStoreTransactionOpenTimeoutWarn() {
        return 0L;
    }

    public int getHousekeepingThreadCount() {
        return 0;
    }

    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies() {
        return Collections.emptyList();
    }

    public int getConnectionThreadPoolSize() {
        return 0;
    }

    public int getNumberOfSelectors() {
        return 0;
    }

    public long getQueueCount() {
        return 0L;
    }

    public long getExchangeCount() {
        return 0L;
    }

    public long getConnectionCount() {
        return 0L;
    }

    public long getBytesIn() {
        return 0L;
    }

    public long getBytesOut() {
        return 0L;
    }

    public long getMessagesIn() {
        return 0L;
    }

    public long getMessagesOut() {
        return 0L;
    }

    public long getBytesEvacuatedFromMemory() {
        return 0L;
    }

    public Collection<? extends Connection<?>> getConnections() {
        return Collections.emptyList();
    }

    public Connection<?> getConnection(String name) {
        return null;
    }

    public int publishMessage(ManageableMessage message) {
        this.throwUnsupportedForReplica();
        return 0;
    }

    public MessageSource getAttainedMessageSource(String name) {
        return null;
    }

    public Queue<?> getAttainedQueue(UUID id) {
        return null;
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return null;
    }

    public MessageDestination getDefaultDestination() {
        return null;
    }

    public MessageStore getMessageStore() {
        return null;
    }

    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupportedForReplica();
        return null;
    }

    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupportedForReplica();
        return null;
    }

    public boolean hasMessageSources() {
        return false;
    }

    public void setTargetSize(long targetSize) {
    }

    public long getTargetSize() {
        return 0L;
    }

    public long getTotalQueueDepthBytes() {
        return 0L;
    }

    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
    }

    public DtxRegistry getDtxRegistry() {
        return null;
    }

    public LinkRegistry getLinkRegistry(String remoteContainerId) {
        return null;
    }

    public ScheduledFuture<?> scheduleTask(long delay, Runnable timeoutTask) {
        this.throwUnsupportedForReplica();
        return null;
    }

    public EventLogger getEventLogger() {
        return null;
    }

    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        return false;
    }

    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        return Collections.emptyMap();
    }

    public Content exportMessageStore() {
        this.throwUnsupportedForReplica();
        return null;
    }

    public void importMessageStore(String source) {
        this.throwUnsupportedForReplica();
    }

    public List<String> getEnabledConnectionValidators() {
        return this._enabledConnectionValidators;
    }

    public List<String> getDisabledConnectionValidators() {
        return this._disabledConnectionValidators;
    }

    public List<String> getGlobalAddressDomains() {
        return this._globalAddressDomains;
    }

    public String getLocalAddress(String routingAddress) {
        String localAddress = routingAddress;
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                if (localAddress.length() <= routingAddress.length() - domain.length() || !routingAddress.startsWith(domain + "/")) continue;
                localAddress = routingAddress.substring(domain.length());
            }
        }
        return localAddress;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public void registerConnection(AMQPConnection<?> connection) {
        this.throwUnsupportedForReplica();
    }

    public void deregisterConnection(AMQPConnection<?> connection) {
        this.throwUnsupportedForReplica();
    }

    private void throwUnsupportedForReplica() {
        throw new IllegalStateException("The virtual host state of " + this.getState() + " does not permit this operation.");
    }

    public void setFirstOpening(boolean firstOpening) {
    }

    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        this.throwUnsupportedForReplica();
        return null;
    }
}

