/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import org.apache.qpid.server.store.Xid;

public class XidBinding
extends TupleBinding<Xid> {
    private static final XidBinding INSTANCE = new XidBinding();

    public static XidBinding getInstance() {
        return INSTANCE;
    }

    private XidBinding() {
    }

    public Xid entryToObject(TupleInput input) {
        long format = input.readLong();
        byte[] globalId = new byte[input.readInt()];
        input.readFast(globalId);
        byte[] branchId = new byte[input.readInt()];
        input.readFast(branchId);
        return new Xid(format, globalId, branchId);
    }

    public void objectToEntry(Xid xid, TupleOutput output) {
        output.writeLong(xid.getFormat());
        output.writeInt(xid.getGlobalId() == null ? 0 : xid.getGlobalId().length);
        if (xid.getGlobalId() != null) {
            output.write(xid.getGlobalId());
        }
        output.writeInt(xid.getBranchId() == null ? 0 : xid.getBranchId().length);
        if (xid.getBranchId() != null) {
            output.write(xid.getBranchId());
        }
    }
}

