/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.DatabaseEntry;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.store.MessageMetaDataTypeRegistry;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaDataBinding
implements EntryBinding<StorableMessageMetaData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageMetaDataBinding.class);
    private static final MessageMetaDataBinding INSTANCE = new MessageMetaDataBinding();

    public static MessageMetaDataBinding getInstance() {
        return INSTANCE;
    }

    private MessageMetaDataBinding() {
    }

    public StorableMessageMetaData entryToObject(DatabaseEntry entry) {
        QpidByteBuffer buf;
        if (entry.getSize() > QpidByteBuffer.getPooledBufferSize()) {
            buf = QpidByteBuffer.wrap((byte[])entry.getData(), (int)entry.getOffset(), (int)entry.getSize());
        } else {
            buf = QpidByteBuffer.allocateDirect((int)entry.getSize());
            buf.put(entry.getData(), entry.getOffset(), entry.getSize());
            buf.flip();
        }
        int bodySize = buf.getInt() ^ Integer.MIN_VALUE;
        int metaDataType = buf.get() & 0xFF;
        QpidByteBuffer slice = buf.slice();
        slice.limit(bodySize - 1);
        MessageMetaDataType type = MessageMetaDataTypeRegistry.fromOrdinal((int)metaDataType);
        StorableMessageMetaData metaData = type.createMetaData(slice);
        slice.dispose();
        buf.dispose();
        return metaData;
    }

    public void objectToEntry(StorableMessageMetaData metaData, DatabaseEntry entry) {
        int bodySize = 1 + metaData.getStorableSize();
        byte[] underlying = new byte[4 + bodySize];
        underlying[4] = (byte)metaData.getType().ordinal();
        QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])underlying);
        buf.putInt(bodySize ^ Integer.MIN_VALUE);
        buf.position(5);
        buf = buf.slice();
        metaData.writeToBuffer(buf);
        entry.setData(underlying);
    }
}

