/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBConfiguredObjectRecord;

public class ConfiguredObjectBinding
extends TupleBinding<ConfiguredObjectRecord> {
    private static final ConfiguredObjectBinding INSTANCE = new ConfiguredObjectBinding(null);
    private final UUID _uuid;

    public static ConfiguredObjectBinding getInstance() {
        return INSTANCE;
    }

    public ConfiguredObjectBinding(UUID uuid) {
        this._uuid = uuid;
    }

    public BDBConfiguredObjectRecord entryToObject(TupleInput tupleInput) {
        String type = tupleInput.readString();
        String json = tupleInput.readString();
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map value = (Map)mapper.readValue(json, Map.class);
            BDBConfiguredObjectRecord configuredObject = new BDBConfiguredObjectRecord(this._uuid, type, value);
            return configuredObject;
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void objectToEntry(ConfiguredObjectRecord object, TupleOutput tupleOutput) {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
            objectMapper.writeValue((Writer)writer, (Object)object.getAttributes());
            tupleOutput.writeString(object.getType());
            tupleOutput.writeString(writer.toString());
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }
}

