/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.google.common.util.concurrent.ListenableFuture;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;

public interface EnvironmentFacade {
    public static final Map<String, String> ENVCONFIG_DEFAULTS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("je.lock.nLockTables", "7");
            this.put("je.stats.collect", "false");
            this.put("com.sleepycat.je.util.FileHandler.level", "OFF");
            this.put("com.sleepycat.je.util.ConsoleHandler.level", "OFF");
            this.put("je.cleaner.upgradeToLogVersion", "-1");
            this.put("je.cleaner.adjustUtilization", "false");
        }
    });
    public static final String CACHE_MODE_PROPERTY_NAME = "qpid.bdb.cache_mode";
    public static final CacheMode CACHE_MODE_DEFAULT = CacheMode.EVICT_LN;
    public static final String LOG_HANDLER_CLEANER_PROTECTED_FILES_LIMIT_PROPERTY_NAME = "qpid.bdb.je.cleaner_protected_files_limit";
    public static final int DEFAULT_LOG_HANDLER_CLEANER_PROTECTED_FILES_LIMIT = 10;

    public void upgradeIfNecessary(ConfiguredObject<?> var1);

    public Database openDatabase(String var1, DatabaseConfig var2);

    public Database clearDatabase(String var1, DatabaseConfig var2);

    public Sequence openSequence(Database var1, DatabaseEntry var2, SequenceConfig var3);

    public Transaction beginTransaction(TransactionConfig var1);

    public void commit(Transaction var1, boolean var2);

    public <X> ListenableFuture<X> commitAsync(Transaction var1, X var2);

    public RuntimeException handleDatabaseException(String var1, RuntimeException var2);

    public void closeDatabase(String var1);

    public void close();

    public long getTotalLogSize();

    public void reduceSizeOnDisk();

    public void flushLog();

    public void setCacheSize(long var1);

    public void flushLogFailed(RuntimeException var1);

    public void updateMutableConfig(ConfiguredObject<?> var1);

    public int cleanLog();

    public void checkpoint(boolean var1);

    public Map<String, Map<String, Object>> getEnvironmentStatistics(boolean var1);

    public Map<String, Object> getTransactionStatistics(boolean var1);

    public Map<String, Object> getDatabaseStatistics(String var1, boolean var2);
}

